/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.crypto.common.asn1.cvc;

import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.openecard.crypto.common.asn1.cvc.CHAT;
import org.openecard.crypto.common.asn1.cvc.CardVerifiableCertificate;
import org.openecard.crypto.common.asn1.cvc.CertificateDescription;
import org.openecard.crypto.common.asn1.cvc.PublicKeyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardVerifiableCertificateChain {
    private static final Logger _logger = LoggerFactory.getLogger(CertificateDescription.class);
    private final ArrayList<CardVerifiableCertificate> certs = new ArrayList();
    private final ArrayList<CardVerifiableCertificate> cvcaCerts = new ArrayList();
    private final ArrayList<CardVerifiableCertificate> dvCerts = new ArrayList();
    private CardVerifiableCertificate terminalCert;

    public CardVerifiableCertificateChain(List<CardVerifiableCertificate> certificates) throws CertificateException {
        this.parseChain(certificates);
        _logger.warn("Verification of the certificate chain is disabled.");
    }

    private void parseChain(List<CardVerifiableCertificate> certificates) throws CertificateException {
        for (CardVerifiableCertificate cvc : certificates) {
            if (this.containsCertificate(cvc)) continue;
            CHAT.Role role = cvc.getCHAT().getRole();
            if (role.equals((Object)CHAT.Role.CVCA)) {
                this.cvcaCerts.add(cvc);
                this.certs.add(cvc);
                continue;
            }
            if (role.equals((Object)CHAT.Role.DV_OFFICIAL) || role.equals((Object)CHAT.Role.DV_NON_OFFICIAL)) {
                this.dvCerts.add(cvc);
                this.certs.add(cvc);
                continue;
            }
            if (role.equals((Object)CHAT.Role.AUTHENTICATION_TERMINAL) || role.equals((Object)CHAT.Role.INSPECTION_TERMINAL) || role.equals((Object)CHAT.Role.SIGNATURE_TERMINAL)) {
                if (this.terminalCert != null) continue;
                this.terminalCert = cvc;
                this.certs.add(cvc);
                continue;
            }
            throw new CertificateException("Malformed certificate.");
        }
    }

    public void verify() throws CertificateException {
        this.verify(Arrays.asList(this.terminalCert), this.dvCerts);
        this.verify(this.dvCerts, this.cvcaCerts);
        this.verify(this.cvcaCerts, this.cvcaCerts);
    }

    private void verify(List<CardVerifiableCertificate> authorities, List<CardVerifiableCertificate> holders) throws CertificateException {
        Iterator<CardVerifiableCertificate> ai = authorities.iterator();
        block0: while (ai.hasNext()) {
            CardVerifiableCertificate authority = ai.next();
            for (CardVerifiableCertificate holder : holders) {
                if (authority.getCAR().equals(holder.getCHR())) continue block0;
                if (ai.hasNext()) continue;
                String msg = String.format("Malformed certificate chain: Cannot find a CHR for the CAR (%s).", authority.getCAR());
                throw new CertificateException(msg);
            }
        }
    }

    public boolean containsCertificate(CardVerifiableCertificate cvc) {
        for (CardVerifiableCertificate c : this.certs) {
            if (!c.compare(cvc)) continue;
            return true;
        }
        return false;
    }

    public void addCertificate(CardVerifiableCertificate certificate) throws CertificateException {
        this.parseChain(Arrays.asList(certificate));
    }

    public void addCertificates(ArrayList<CardVerifiableCertificate> certificates) throws CertificateException {
        this.parseChain(certificates);
    }

    public List<CardVerifiableCertificate> getCVCACertificates() {
        return this.cvcaCerts;
    }

    public List<CardVerifiableCertificate> getDVCertificates() {
        return this.dvCerts;
    }

    public CardVerifiableCertificate getTerminalCertificate() {
        return this.terminalCert;
    }

    public List<CardVerifiableCertificate> getCertificates() {
        return this.certs;
    }

    public CardVerifiableCertificateChain getCertificateChainFromCAR(byte[] car) throws CertificateException {
        return this.getCertificateChainFromCAR(new PublicKeyReference(car));
    }

    public CardVerifiableCertificateChain getCertificateChainFromCAR(PublicKeyReference car) throws CertificateException {
        ArrayList<CardVerifiableCertificate> certChain = this.buildChain(this.certs, car);
        return new CardVerifiableCertificateChain(certChain);
    }

    private ArrayList<CardVerifiableCertificate> buildChain(ArrayList<CardVerifiableCertificate> certs, PublicKeyReference car) {
        ArrayList<CardVerifiableCertificate> certChain = new ArrayList<CardVerifiableCertificate>();
        for (CardVerifiableCertificate c : certs) {
            if (!c.getCAR().compare(car)) continue;
            certChain.add(c);
            certChain.addAll(this.buildChain(certs, c.getCHR()));
        }
        return certChain;
    }
}

