/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.interceptor;

import java.io.IOException;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.HttpResponseInterceptor;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.common.AppVersion;

public class ServerHeaderResponseInterceptor
implements HttpResponseInterceptor {
    @Override
    public void process(HttpResponse hr, HttpContext hc) throws HttpException, IOException {
        hr.addHeader("Server", this.buildServerHeaderValue());
    }

    public String buildServerHeaderValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(AppVersion.getName());
        builder.append("/");
        builder.append(AppVersion.getVersion());
        builder.append(" (");
        boolean firstSpec = true;
        for (String version : AppVersion.getSpecVersions()) {
            if (!firstSpec) {
                builder.append(" ");
            } else {
                firstSpec = false;
            }
            builder.append(AppVersion.getSpecName());
            builder.append("/");
            builder.append(version);
        }
        builder.append(")");
        return builder.toString();
    }
}

