/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.interceptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openecard.apache.http.Header;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpResponse;
import org.openecard.apache.http.HttpResponseInterceptor;
import org.openecard.apache.http.StatusLine;
import org.openecard.apache.http.entity.ContentType;
import org.openecard.apache.http.entity.StringEntity;
import org.openecard.apache.http.protocol.HttpContext;
import org.openecard.common.I18n;
import org.openecard.common.util.HTMLUtils;
import org.openecard.control.binding.http.common.DocumentRoot;
import org.openecard.control.binding.http.common.HTTPTemplate;
import org.openecard.control.binding.http.common.HeaderTypes;
import org.openecard.control.binding.http.common.MimeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponseInterceptor
implements HttpResponseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorResponseInterceptor.class);
    private static I18n lang = I18n.getTranslation("http");
    private final HTTPTemplate template;
    private final List<Integer> errorCodes;

    public ErrorResponseInterceptor(DocumentRoot documentRoot, String template) {
        this(documentRoot, template, ErrorResponseInterceptor.generateErrorCodes());
    }

    public ErrorResponseInterceptor(DocumentRoot documentRoot, String template, List<Integer> errorCodes) {
        this.template = new HTTPTemplate(documentRoot, template);
        this.errorCodes = errorCodes;
    }

    @Override
    public void process(HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (this.errorCodes.contains(statusCode)) {
            LOG.debug("HTTP response intercepted");
            Header contentType = httpResponse.getFirstHeader(HeaderTypes.CONTENT_TYPE.fieldName());
            if (contentType != null) {
                if (contentType.getValue().contains(MimeType.TEXT_PLAIN.getMimeType())) {
                    httpResponse.removeHeaders(HeaderTypes.CONTENT_TYPE.fieldName());
                    httpResponse.removeHeaders(HeaderTypes.CONTENT_LENGTH.fieldName());
                    String content = this.readEntity(httpResponse.getEntity());
                    content = HTMLUtils.escapeHtml(content);
                    this.template.setProperty("%%%MESSAGE%%%", content);
                }
            } else {
                this.template.setProperty("%%%MESSAGE%%%", lang.translationForKey("http." + statusCode, new Object[0]));
            }
            this.template.setProperty("%%%TITLE%%%", "Error");
            String reason = statusLine.getReasonPhrase();
            this.template.setProperty("%%%HEADLINE%%%", reason);
            httpResponse.setEntity(new StringEntity(this.template.toString(), "UTF-8"));
            httpResponse.addHeader(HeaderTypes.CONTENT_TYPE.fieldName(), MimeType.TEXT_HTML.getMimeType() + "; charset=utf-8");
            httpResponse.addHeader(HeaderTypes.CONTENT_LENGTH.fieldName(), String.valueOf(this.template.getBytes().length));
        }
    }

    private String readEntity(HttpEntity httpEntity) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        httpEntity.writeTo(baos);
        ContentType type = ContentType.getOrDefault(httpEntity);
        return new String(baos.toByteArray(), type.getCharset());
    }

    private static ArrayList<Integer> generateErrorCodes() {
        int i;
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (i = 400; i <= 417; ++i) {
            result.add(i);
        }
        result.add(423);
        result.add(429);
        for (i = 500; i <= 505; ++i) {
            result.add(i);
        }
        return result;
    }
}

