/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.handler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OriginsList {
    private static final Logger LOG = LoggerFactory.getLogger(OriginsList.class);
    private static Set<URI> whitelist;

    private static synchronized void load() {
        TreeSet<URI> wl = new TreeSet<URI>();
        try {
            InputStream bundledWl = FileUtils.resolveResourceAsStream(OriginsList.class, "origins.list");
            OriginsList.readWhitelist(wl, bundledWl);
            File homePath = FileUtils.getHomeConfigDir();
            File cfgFile = new File(homePath, "origins.whitelist");
            if (cfgFile.isFile() && cfgFile.canRead()) {
                FileInputStream homeWl = new FileInputStream(cfgFile);
                OriginsList.readWhitelist(wl, homeWl);
            }
        }
        catch (IOException | SecurityException ex) {
            LOG.error("Failed to read CORS whitelist.", ex);
        }
        whitelist = wl;
    }

    private static void readWhitelist(Set<URI> wl, InputStream is) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        while ((nextLine = br.readLine()) != null) {
            if ((nextLine = nextLine.trim()).startsWith("#") || nextLine.isEmpty()) continue;
            try {
                URI nextUri = new URI(nextLine);
                wl.add(nextUri);
                LOG.debug("Added '{}' to origin whitelist.", (Object)nextLine);
            }
            catch (URISyntaxException ex) {
                LOG.warn("Failed to add URL '{}' to the whitelist.", (Object)nextLine);
            }
        }
    }

    @Nonnull
    public static File getUserWhitelist() throws IOException, SecurityException {
        File homePath = FileUtils.getHomeConfigDir();
        File cfgFile = new File(homePath, "origins.whitelist");
        if (!cfgFile.exists()) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(cfgFile), StandardCharsets.UTF_8);
            try (PrintWriter pw = new PrintWriter(w);){
                pw.println("##");
                pw.println("## List of allowed CORS origins");
                pw.println("## ----------------------------");
                pw.println("## Entries must follow the CORS specification. One origin entry per file.");
                pw.println("## Comments begin with the # character.");
                pw.println("## Example: https://example.com");
                pw.println("##");
            }
        }
        return cfgFile;
    }

    public static boolean isValidOrigin(@Nonnull String origin) throws URISyntaxException {
        URI uri = new URI(origin);
        return OriginsList.isValidOrigin(uri);
    }

    public static boolean isValidOrigin(@Nonnull URI origin) {
        boolean whitelisted = whitelist.contains(origin);
        return whitelisted;
    }

    static {
        OriginsList.load();
    }
}

