/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http.common;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openecard.apache.http.HttpEntity;
import org.openecard.apache.http.HttpEntityEnclosingRequest;
import org.openecard.apache.http.HttpRequest;
import org.openecard.apache.http.util.EntityUtils;
import org.openecard.common.util.HttpRequestLineUtils;
import org.openecard.control.binding.http.common.Http11Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestWrapper {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestWrapper.class);
    private final HttpRequest request;
    private final Map<String, List<String>> parameterMap;

    public HttpRequestWrapper(HttpRequest request) {
        this.request = request;
        this.parameterMap = new HashMap<String, List<String>>();
        this.parseRequestParameters();
    }

    public Map<String, List<String>> getRequestParameters() {
        if (!this.parameterMap.isEmpty()) {
            return this.parameterMap;
        }
        return null;
    }

    public List<String> getRequestParameter(String parameterName) {
        if (this.parameterMap.containsKey(parameterName)) {
            return this.parameterMap.get(parameterName);
        }
        return null;
    }

    public boolean hasRequestParameter(String parameterName) {
        return this.parameterMap.containsKey(parameterName);
    }

    private Map<String, List<String>> parseRequestParameters() {
        block8: {
            String method;
            block7: {
                Map<String, String> queries;
                method = this.request.getRequestLine().getMethod();
                if (!method.equals(Http11Method.GET.getMethodString())) break block7;
                String query = URI.create(this.request.getRequestLine().getUri()).getRawQuery();
                if (query == null) {
                    return this.parameterMap;
                }
                try {
                    queries = HttpRequestLineUtils.transform(query);
                }
                catch (UnsupportedEncodingException ex) {
                    queries = HttpRequestLineUtils.transformRaw(query);
                }
                for (Map.Entry<String, String> next : queries.entrySet()) {
                    String name = next.getKey();
                    String value = next.getValue();
                    if (this.parameterMap.containsKey(name)) {
                        this.parameterMap.get(name).add(value);
                        continue;
                    }
                    ArrayList<String> values = new ArrayList<String>();
                    values.add(value);
                    this.parameterMap.put(name, values);
                }
                break block8;
            }
            if (!method.equals(Http11Method.POST.getMethodString()) || !(this.request instanceof HttpEntityEnclosingRequest)) break block8;
            HttpEntity entity = ((HttpEntityEnclosingRequest)this.request).getEntity();
            try {
                String entityContent = EntityUtils.toString(entity, "UTF-8");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.parameterMap;
    }
}

