/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.control.binding.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import org.openecard.apache.http.ConnectionClosedException;
import org.openecard.apache.http.HttpException;
import org.openecard.apache.http.HttpRequestInterceptor;
import org.openecard.apache.http.HttpResponseInterceptor;
import org.openecard.apache.http.impl.DefaultBHttpServerConnection;
import org.openecard.apache.http.impl.DefaultConnectionReuseStrategy;
import org.openecard.apache.http.impl.DefaultHttpResponseFactory;
import org.openecard.apache.http.protocol.BasicHttpContext;
import org.openecard.apache.http.protocol.HttpRequestHandler;
import org.openecard.apache.http.protocol.ImmutableHttpProcessor;
import org.openecard.apache.http.protocol.UriHttpRequestHandlerMapper;
import org.openecard.control.binding.http.HttpServiceError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpService
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpService.class);
    private static final int BACKLOG = 10;
    private final Thread thread;
    private final org.openecard.apache.http.protocol.HttpService service;
    protected final ServerSocket server;

    public HttpService(int port, HttpRequestHandler handler, List<HttpRequestInterceptor> reqInterceptors, List<HttpResponseInterceptor> respInterceptors) throws Exception {
        this.thread = new Thread((Runnable)this, "Open-eCard Localhost-Binding-" + port);
        this.server = new ServerSocket(port, 10, InetAddress.getByName("127.0.0.1"));
        LOG.debug("Starting HTTPBinding on port {}", (Object)this.server.getLocalPort());
        DefaultConnectionReuseStrategy connectionReuseStrategy = new DefaultConnectionReuseStrategy();
        DefaultHttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
        ImmutableHttpProcessor httpProcessor = new ImmutableHttpProcessor(reqInterceptors, respInterceptors);
        UriHttpRequestHandlerMapper handlerRegistry = new UriHttpRequestHandlerMapper();
        LOG.debug("Add handler [{}] for ID [{}]", new Object[]{handler.getClass().getCanonicalName(), "*"});
        handlerRegistry.register("*", handler);
        this.service = new org.openecard.apache.http.protocol.HttpService(httpProcessor, connectionReuseStrategy, responseFactory, handlerRegistry);
    }

    public void start() {
        this.thread.start();
    }

    public void interrupt() {
        try {
            this.thread.interrupt();
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Socket accept() throws IOException, HttpServiceError {
        return this.server.accept();
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                CharsetDecoder dec = Charset.forName("UTF-8").newDecoder();
                CharsetEncoder enc = Charset.forName("UTF-8").newEncoder();
                final DefaultBHttpServerConnection connection = new DefaultBHttpServerConnection(8192, dec, enc, null);
                connection.bind(this.accept());
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (connection.isOpen()) {
                                HttpService.this.service.handleRequest(connection, new BasicHttpContext());
                            }
                        }
                        catch (ConnectionClosedException connectionClosedException) {
                        }
                        catch (HttpException ex) {
                            LOG.error("Error processing HTTP request or response.", ex);
                        }
                        catch (IOException ex) {
                            LOG.error("IO Error while processing HTTP request or response.", ex);
                        }
                        finally {
                            try {
                                connection.shutdown();
                            }
                            catch (IOException ex) {}
                        }
                    }
                }.start();
            }
            catch (IOException | HttpServiceError ex) {
                if (!Thread.interrupted()) {
                    LOG.error(ex.getMessage(), ex);
                    continue;
                }
                this.thread.interrupt();
            }
        }
    }

    public int getPort() {
        return this.server.getLocalPort();
    }
}

