/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.openecard.common.util.RemoveAction;
import org.openecard.common.util.RemoveActionFactory;

public class SelfCleaningMap<K extends Comparable, V>
implements Map<K, V> {
    private static final long RERUN = 30000L;
    private static final AtomicInteger THREAD_NUM = new AtomicInteger(1);
    private final long kill;
    private final RemoveActionFactory<V> actionFactory;
    private Map<K, Entry> _map;
    private Cleaner cleaner = null;

    public <M extends Map> SelfCleaningMap(Class<M> c) throws InstantiationException, IllegalAccessException {
        this(c, 900);
    }

    public <M extends Map> SelfCleaningMap(Class<M> c, RemoveActionFactory<V> actionFactory) throws InstantiationException, IllegalAccessException {
        this(c, actionFactory, 900);
    }

    public <M extends Map> SelfCleaningMap(Class<M> c, int lifetime) throws InstantiationException, IllegalAccessException {
        this(c, null, lifetime);
    }

    public <M extends Map> SelfCleaningMap(Class<M> c, RemoveActionFactory<V> actionFactory, int lifetime) throws InstantiationException, IllegalAccessException {
        this.kill = lifetime * 1000;
        this.actionFactory = actionFactory;
        this._map = (Map)c.newInstance();
    }

    private boolean hasAction() {
        return this.actionFactory != null;
    }

    private RemoveAction<V> getAction(V v) {
        return this.actionFactory.create(v);
    }

    @Override
    public synchronized int size() {
        return this._map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public synchronized void putAll(Map m) {
        for (Map.Entry next : m.entrySet()) {
            Entry e = new Entry(next.getValue());
            this._map.put((Comparable)next.getKey(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clear() {
        Iterator<Map.Entry<K, Entry>> i = this._map.entrySet().iterator();
        while (i.hasNext()) {
            Object v;
            Map.Entry<K, Entry> e = i.next();
            if (this.hasAction()) {
                this.getAction(e.getValue().v).perform();
            }
            i.remove();
            Object v2 = v = e.getValue().v;
            synchronized (v2) {
                v.notifyAll();
            }
        }
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException("It is not safe to request lists of objects which may get deleted in another thread.");
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException("It is not safe to request lists of objects which may get deleted in another thread.");
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("It is not safe to request lists of objects which may get deleted in another thread.");
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        boolean result = this._map.containsKey((Comparable)key);
        if (result) {
            this.get((Comparable)key);
        }
        return result;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        for (Map.Entry<K, Entry> next : this._map.entrySet()) {
            Object v = next.getValue().v;
            if ((value != null || v != null) && (value == null || !value.equals(v))) continue;
            next.getValue().d.setTime(System.currentTimeMillis());
            return true;
        }
        return false;
    }

    @Override
    public synchronized V get(Object key) {
        Entry e = this._map.get((Comparable)key);
        if (e != null) {
            e.d.setTime(System.currentTimeMillis());
            return e.v;
        }
        return null;
    }

    @Override
    public synchronized V put(K key, V value) {
        Entry result;
        if (this.cleaner == null) {
            this.cleaner = new Cleaner();
            this.cleaner.start();
        }
        return (result = this._map.put(key, new Entry(value))) == null ? null : (V)result.v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized V remove(Object key) {
        Entry e = this._map.remove((Comparable)key);
        if (this.hasAction()) {
            this.getAction(e.v).perform();
        }
        if (e != null) {
            Object v = e.v;
            synchronized (v) {
                e.v.notifyAll();
            }
            return e.v;
        }
        return null;
    }

    private class Cleaner
    extends Thread {
        public Cleaner() {
            super(String.format("MapCleaner-%d", THREAD_NUM.getAndIncrement()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Cleaner cleaner = this;
            synchronized (cleaner) {
                while (!SelfCleaningMap.this._map.isEmpty()) {
                    try {
                        this.wait(30000L);
                        long now = System.currentTimeMillis();
                        Iterator i = SelfCleaningMap.this._map.entrySet().iterator();
                        while (i.hasNext()) {
                            Object v;
                            Map.Entry e = i.next();
                            long old = ((Entry)e.getValue()).d.getTime();
                            if (now - old <= SelfCleaningMap.this.kill) continue;
                            if (SelfCleaningMap.this.hasAction()) {
                                SelfCleaningMap.this.getAction(((Entry)e.getValue()).v).perform();
                            }
                            i.remove();
                            Object v2 = v = ((Entry)e.getValue()).v;
                            synchronized (v2) {
                                v.notifyAll();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                SelfCleaningMap.this.cleaner = null;
            }
        }
    }

    private class Entry {
        public final V v;
        public final Date d;

        public Entry(V v) {
            this.v = v;
            this.d = new Date();
        }

        public Entry(V v, Date d) {
            this.v = v;
            this.d = d;
        }
    }
}

