/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxLibraryFinder {
    private static final Logger logger = LoggerFactory.getLogger(LinuxLibraryFinder.class);

    @Nonnull
    public static File getLibraryPath(@Nonnull String name, @Nullable String version) throws FileNotFoundException {
        version = version == null ? "" : version;
        version = version.isEmpty() ? "" : "." + version;
        String libname = System.mapLibraryName(name) + version;
        File result = LinuxLibraryFinder.findInEnv(libname, System.getenv("LD_LIBRARY_PATH"));
        if (result != null) {
            return result;
        }
        result = LinuxLibraryFinder.findInLdCache(libname);
        if (result != null) {
            return result;
        }
        result = LinuxLibraryFinder.findInBaseLibPaths(libname);
        if (result != null) {
            return result;
        }
        throw new FileNotFoundException("Library " + libname + " not found on your system.");
    }

    @Nullable
    private static File findInEnv(@Nonnull String libname, @Nullable String env) {
        if (env != null) {
            for (String path : env.split(":")) {
                String result = path + "/" + libname;
                File test = new File(result.trim());
                if (!test.canRead()) continue;
                return test;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static File findInLdCache(@Nonnull String libname) {
        String ldconfExec = LinuxLibraryFinder.findProgramFile("ldconfig") + " -p";
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(ldconfExec);
            InputStream cacheData = p.getInputStream();
            BufferedReader cacheDataReader = new BufferedReader(new InputStreamReader(cacheData));
            while (true) {
                String next;
                if ((next = cacheDataReader.readLine()) != null) {
                    String result;
                    File test;
                    if (!next.endsWith(libname)) continue;
                    int endIdx = next.lastIndexOf("=>");
                    if (endIdx == -1 || !(test = new File((result = next.substring(endIdx + 2)).trim())).canRead()) continue;
                    File file = test;
                    return file;
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            logger.debug("Library {} not found in ld.so.cache.", (Object)libname);
        }
        finally {
            if (p != null) {
                try {
                    p.getInputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException iOException) {}
                try {
                    p.getErrorStream().close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    @Nonnull
    private static String findProgramFile(@Nonnull String name) {
        String path = System.getenv().get("PATH");
        path = path == null ? "" : path;
        path = "/sbin:/usr/sbin:" + path;
        for (String entry : path.split(":")) {
            String fname = entry + "/" + name;
            File f = new File(fname);
            if (!f.canExecute()) continue;
            return fname;
        }
        return name;
    }

    @Nullable
    private static File findInBaseLibPaths(@Nonnull String libname) {
        String[] basePaths;
        String archSuffix = "64".equals(System.getProperty("sun.arch.data.model")) ? "64" : "";
        for (String path : basePaths = new String[]{"/lib" + archSuffix, "/usr/lib" + archSuffix}) {
            String fname = path + "/" + libname;
            File test = new File(fname);
            if (!test.canRead()) continue;
            return test;
        }
        return null;
    }
}

