/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.LongUtils;

public class IntegerUtils {
    public static byte[] toByteArray(int value) {
        return IntegerUtils.toByteArray(value, 8);
    }

    public static byte[] toByteArray(int value, int numBits) {
        return IntegerUtils.toByteArray(value, numBits, true);
    }

    public static byte[] toByteArray(int value, int numBits, boolean bigEndian) {
        return LongUtils.toByteArray((long)value, numBits, bigEndian);
    }

    public static byte[] toByteArray(int value, boolean padArrayToTypeLength) {
        return IntegerUtils.toByteArray(value, padArrayToTypeLength, true);
    }

    public static byte[] toByteArray(int value, boolean padArrayToTypeLength, boolean bigEndian) {
        byte[] result = IntegerUtils.toByteArray(value, 8, bigEndian);
        if (padArrayToTypeLength && result.length < 4) {
            result = ByteUtils.concatenate(new byte[4 - result.length], result);
        }
        return result;
    }
}

