/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import iso.std.iso_iec._24727.tech.schema.CardApplicationPathType;
import iso.std.iso_iec._24727.tech.schema.ChannelHandleType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import iso.std.iso_iec._24727.tech.schema.PathSecurityType;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.HandlerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandlerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HandlerUtils.class);

    public HandlerBuilder createBuilder() {
        return HandlerBuilder.create();
    }

    public static ConnectionHandleType copyHandle(ConnectionHandleType handle) {
        ConnectionHandleType result = new ConnectionHandleType();
        HandlerUtils.copyPath(result, handle);
        result.setSlotHandle(ByteUtils.clone(handle.getSlotHandle()));
        result.setRecognitionInfo(HandlerUtils.copyRecognition(handle.getRecognitionInfo()));
        result.setSlotInfo(HandlerUtils.copySlotInfo(handle.getSlotInfo()));
        return result;
    }

    public static CardApplicationPathType copyPath(CardApplicationPathType handle) {
        CardApplicationPathType result = new CardApplicationPathType();
        HandlerUtils.copyPath(result, handle);
        return result;
    }

    private static void copyPath(CardApplicationPathType out, CardApplicationPathType in) {
        out.setCardApplication(ByteUtils.clone(in.getCardApplication()));
        out.setChannelHandle(HandlerUtils.copyChannel(in.getChannelHandle()));
        out.setContextHandle(ByteUtils.clone(in.getContextHandle()));
        out.setIFDName(in.getIFDName());
        out.setSlotIndex(in.getSlotIndex());
    }

    private static ChannelHandleType copyChannel(ChannelHandleType handle) {
        if (handle == null) {
            return null;
        }
        ChannelHandleType result = new ChannelHandleType();
        result.setBinding(handle.getBinding());
        result.setPathSecurity(HandlerUtils.copyPathSec(handle.getPathSecurity()));
        result.setProtocolTerminationPoint(handle.getProtocolTerminationPoint());
        result.setSessionIdentifier(handle.getSessionIdentifier());
        return result;
    }

    private static ConnectionHandleType.RecognitionInfo copyRecognition(ConnectionHandleType.RecognitionInfo rec) {
        if (rec == null) {
            return null;
        }
        ConnectionHandleType.RecognitionInfo result = new ConnectionHandleType.RecognitionInfo();
        if (rec.getCaptureTime() != null) {
            result.setCaptureTime((XMLGregorianCalendar)rec.getCaptureTime().clone());
        }
        result.setCardIdentifier(ByteUtils.clone(rec.getCardIdentifier()));
        result.setCardType(rec.getCardType());
        return result;
    }

    private static PathSecurityType copyPathSec(PathSecurityType sec) {
        if (sec == null) {
            return null;
        }
        PathSecurityType result = new PathSecurityType();
        result.setParameters(sec.getParameters());
        result.setProtocol(sec.getProtocol());
        return result;
    }

    private static ConnectionHandleType.SlotInfo copySlotInfo(ConnectionHandleType.SlotInfo slotInfo) {
        if (slotInfo == null) {
            return null;
        }
        ConnectionHandleType.SlotInfo result = new ConnectionHandleType.SlotInfo();
        result.setProtectedAuthPath(slotInfo.isProtectedAuthPath());
        return result;
    }

    public static ConnectionHandleType extractHandle(@Nonnull Object obj) {
        ConnectionHandleType handle = HandlerUtils.getMember(obj, "getConnectionHandle", ConnectionHandleType.class);
        if (handle != null) {
            LOG.debug("Found ConnectionHandle in object of type {}.", (Object)obj.getClass().getSimpleName());
            return handle;
        }
        byte[] ctxHandle = HandlerUtils.getMember(obj, "getContextHandle", byte[].class);
        if (ctxHandle != null) {
            LOG.debug("Found ContextHandle in object of type {}.", (Object)obj.getClass().getSimpleName());
            String ifdName = HandlerUtils.getMember(obj, "getIFDName", String.class);
            String sessionId = HandlerUtils.getMember(obj, "getSessionIdentifier", String.class);
            return HandlerBuilder.create().setContextHandle(ctxHandle).setIfdName(ifdName).setSessionId(sessionId).buildConnectionHandle();
        }
        byte[] slotHandle = HandlerUtils.getMember(obj, "getSlotHandle", byte[].class);
        if (slotHandle != null) {
            LOG.debug("Found SlotHandle in object of type {}.", (Object)obj.getClass().getSimpleName());
            return HandlerBuilder.create().setSlotHandle(slotHandle).buildConnectionHandle();
        }
        return null;
    }

    private static <T> T getMember(Object obj, String methodName, Class<T> memberType) {
        try {
            Method getter = obj.getClass().getMethod(methodName, new Class[0]);
            if (memberType.equals(getter.getReturnType())) {
                return memberType.cast(getter.invoke(obj, new Object[0]));
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }
}

