/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.openecard.bouncycastle.util.Strings;
import org.openecard.bouncycastle.util.encoders.Base64Encoder;
import org.openecard.bouncycastle.util.encoders.Encoder;

public class FileSafeBase64
extends Base64Encoder {
    private static final Encoder encoder = new FileSafeBase64();

    public FileSafeBase64() {
        this.encodingTable[62] = 45;
        this.encodingTable[63] = 95;
        this.initialiseDecodingTable();
    }

    public static String toBase64String(byte[] data) {
        byte[] encoded = FileSafeBase64.encodeData(data);
        return Strings.fromByteArray(encoded);
    }

    public static byte[] encodeData(byte[] data) {
        try {
            int inLength = data.length;
            int outLength = (inLength + 2) / 3 * 4;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(outLength);
            FileSafeBase64.encodeData(data, bOut);
            return bOut.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write encoded data to memory.", ex);
        }
    }

    public static int encodeData(byte[] data, OutputStream out) throws IOException {
        int inLength = data.length;
        return encoder.encode(data, 0, inLength, out);
    }

    public static byte[] decodeData(byte[] data) {
        try {
            int outLength = data.length / 4 * 3;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(outLength);
            FileSafeBase64.decodeData(data, (OutputStream)bOut);
            return bOut.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write decoded data to memory.", ex);
        }
    }

    public static int decodeData(byte[] data, OutputStream out) throws IOException {
        return encoder.decode(data, 0, data.length, out);
    }

    public static byte[] decodeData(String data) {
        try {
            int outLength = data.length() / 4 * 3;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(outLength);
            FileSafeBase64.decodeData(data, (OutputStream)bOut);
            return bOut.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write decoded data to memory.", ex);
        }
    }

    public static int decodeData(String data, OutputStream out) throws IOException {
        return encoder.decode(data, out);
    }
}

