/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.util;

import java.net.IDN;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DomainUtils.class);

    public static boolean checkHostName(@Nonnull String referenceHost, @Nonnull String actualHost) throws IllegalArgumentException {
        return DomainUtils.checkHostName(referenceHost, actualHost, false);
    }

    public static boolean checkWildcardHostName(@Nonnull String referenceHost, @Nonnull String actualHost) throws IllegalArgumentException {
        return DomainUtils.checkHostName(referenceHost, actualHost, true);
    }

    public static boolean checkHostName(@Nonnull String referenceHost, @Nonnull String actualHost, boolean allowWildcard) throws IllegalArgumentException {
        try {
            String[] refToken;
            if (!allowWildcard && referenceHost.startsWith("*")) {
                return false;
            }
            String[] actualToken = IDN.toASCII(actualHost).split("\\.");
            if (actualToken.length != (refToken = IDN.toASCII(referenceHost).split("\\.")).length) {
                return false;
            }
            for (int i = actualToken.length - 1; i >= 0; --i) {
                if (i == 0 && refToken[i].equals("*") || actualToken[i].equalsIgnoreCase(refToken[i])) continue;
                return false;
            }
            return true;
        }
        catch (IllegalArgumentException ex) {
            String msg = "Error normalizing international domain name.";
            LOG.warn(msg, ex);
            throw new IllegalArgumentException(msg, ex);
        }
    }
}

