/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Path;
import org.openecard.common.tlv.iso7816.TLVType;

public class ReferencedValue
extends TLVType {
    private Path path;
    private TLV url;

    public ReferencedValue(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(Tag.SEQUENCE_TAG)) {
            this.path = new Path(p.next(0));
        } else if (p.match(new Tag(TagClass.UNIVERSAL, true, 19L)) || p.match(new Tag(TagClass.UNIVERSAL, true, 22L)) || p.match(new Tag(TagClass.CONTEXT, false, 3L))) {
            this.url = p.next(0);
        } else {
            throw new TLVException("Unexpected element in ObjectValue.");
        }
    }

    public Path getPath() {
        return this.path;
    }

    public TLV getURL() {
        return this.url;
    }
}

