/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.Path;
import org.openecard.common.tlv.iso7816.TLVBitString;
import org.openecard.common.tlv.iso7816.TLVType;

public class PrivateECKeyAttributes
extends TLVType {
    private Path value;
    private TLV implicitCA;
    private TLV named;
    private TLV specified;
    private TLVBitString operations;

    public PrivateECKeyAttributes(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (!p.match(Tag.SEQUENCE_TAG)) {
            throw new TLVException("No value element in structure.");
        }
        this.value = new Path(p.next(0));
        if (p.match(Tag.SEQUENCE_TAG)) {
            Parser p1 = new Parser(p.next(0).getChild());
            if (p1.match(new Tag(TagClass.UNIVERSAL, true, 5L))) {
                this.implicitCA = p1.next(0);
            } else if (p1.match(new Tag(TagClass.UNIVERSAL, true, 6L))) {
                this.named = p1.next(0);
            } else if (p1.match(Tag.SEQUENCE_TAG)) {
                this.specified = p1.next(0);
            } else {
                throw new TLVException("No parameters element in structure.");
            }
            if (p1.match(new Tag(TagClass.UNIVERSAL, true, 3L))) {
                this.operations = new TLVBitString(p1.next(0), new Tag(TagClass.UNIVERSAL, true, 3L).getTagNumWithClass());
            }
        }
    }

    public TLV getImplicitCA() {
        return this.implicitCA;
    }

    public TLV getNamed() {
        return this.named;
    }

    public TLV getSpecified() {
        return this.specified;
    }

    public TLVBitString getOperations() {
        return this.operations;
    }
}

