/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.util.ByteUtils;

public class Path {
    private final TLV tlv;
    private byte[] efIdOrPath;
    private Integer index;
    private Integer length;

    public Path(TLV tlv) throws TLVException {
        this.tlv = tlv;
        Parser p = new Parser(tlv.getChild());
        if (!p.match(new Tag(TagClass.UNIVERSAL, true, 4L))) {
            throw new TLVException("No efIdOrPath given.");
        }
        this.efIdOrPath = p.next(0).getValue();
        this.index = null;
        this.length = null;
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 2L)) && p.matchLA(1, new Tag(TagClass.CONTEXT, true, 0L))) {
            this.index = ByteUtils.toInteger(p.next(0).getValue());
            this.length = ByteUtils.toInteger(p.next(0).getValue());
        }
    }

    public Path(byte[] data) throws TLVException {
        this(TLV.fromBER(data));
    }

    public byte[] efIdOrPath() {
        return this.efIdOrPath;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Integer getLength() {
        return this.length;
    }
}

