/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.CommonObjectAttributes;

public class GenericDataContainerObject<ObjectType> {
    private TLV tlv;
    private CommonObjectAttributes commonObjectAttributes;
    private TLV classAttributes;
    private TLV subClassAttributes;
    private ObjectType typeAttributes;

    public GenericDataContainerObject(TLV tlv, Class<ObjectType> clazz) throws TLVException {
        Constructor<ObjectType> c;
        try {
            c = clazz.getConstructor(TLV.class);
        }
        catch (Exception ex) {
            throw new TLVException("AuthAttributes supplied doesn't have a constructor AuthAttributes(TLV).");
        }
        this.tlv = tlv;
        Parser p = new Parser(tlv.getChild());
        if (!p.match(Tag.SEQUENCE_TAG)) {
            throw new TLVException("CommonDataContainerObjectAttributes not present.");
        }
        this.commonObjectAttributes = new CommonObjectAttributes(p.next(0));
        if (!p.match(Tag.SEQUENCE_TAG)) {
            throw new TLVException("CommonObjectAttributes not present.");
        }
        this.classAttributes = p.next(0);
        if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.subClassAttributes = p.next(0).getChild();
        }
        if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            try {
                this.typeAttributes = c.newInstance(p.next(0).getChild());
            }
            catch (InvocationTargetException ex) {
                throw new TLVException(ex);
            }
            catch (Exception ex) {
                throw new TLVException("AuthAttributes supplied doesn't have a constructor AuthAttributes(TLV).");
            }
        }
    }

    public CommonObjectAttributes getCommonObjectAttributes() {
        return this.commonObjectAttributes;
    }

    public TLV getClassAttributes() {
        return this.classAttributes;
    }

    public TLV getSubClassAttributes() {
        return this.subClassAttributes;
    }

    public ObjectType getTypeAttributes() {
        return this.typeAttributes;
    }
}

