/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.iso7816.ApplicationTemplate;
import org.openecard.common.util.Pair;

public class FMD {
    private final TLV tlv;
    boolean content;
    private byte[] discretionaryData;
    private byte[] discretionaryDataTemplate;
    private List<ApplicationTemplate> applicationTemplates;
    private String applicationLabel;
    private byte[] fileReference;
    private String uniformResourceLocator;
    private List<Pair<byte[], byte[]>> references;
    private List<TLV> proprietaryInformation;

    public FMD(TLV tlv) throws TLVException, UnsupportedEncodingException {
        block7: {
            TLV child;
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block6: {
                                            this.content = true;
                                            this.tlv = tlv;
                                            child = tlv.getChild();
                                            if (child.getTagNumWithClass() != 100L) {
                                                throw new TLVException("Data doesn't represent an FCP.");
                                            }
                                            if (tlv.getValue().length != 0) break block6;
                                            this.content = false;
                                            break block7;
                                        }
                                        if (child.getTagNumWithClass() != 97L) break block8;
                                        Parser p = new Parser(child);
                                        this.applicationTemplates = new LinkedList<ApplicationTemplate>();
                                        while (p.match(97L)) {
                                            if (!p.match(97L)) continue;
                                            this.applicationTemplates.add(new ApplicationTemplate(p.next(0)));
                                        }
                                        break block7;
                                    }
                                    if (child.getTagNumWithClass() != 83L) break block9;
                                    this.discretionaryData = child.getValue();
                                    break block7;
                                }
                                if (child.getTagNumWithClass() != 115L) break block10;
                                this.discretionaryDataTemplate = child.getValue();
                                break block7;
                            }
                            if (child.getTagNumWithClass() != 24400L) break block11;
                            this.uniformResourceLocator = new String(child.getValue(), "ASCII-US");
                            break block7;
                        }
                        if (child.getTagNumWithClass() != 80L) break block12;
                        this.applicationLabel = new String(child.getValue());
                        break block7;
                    }
                    if (child.getTagNumWithClass() != 81L) break block13;
                    this.fileReference = child.getValue();
                    break block7;
                }
                if (child.getTagNumWithClass() != 162L) break block14;
                Parser p = new Parser(child);
                this.references = new ArrayList<Pair<byte[], byte[]>>();
                while (p.match(136L) || p.match(81L)) {
                    byte[] shortRef = null;
                    byte[] fileRef = null;
                    if (p.match(136L)) {
                        shortRef = p.next(0).getValue();
                    }
                    if (p.match(81L)) {
                        fileRef = p.next(0).getValue();
                    }
                    Pair<byte[], byte[]> refPair = new Pair<byte[], byte[]>(shortRef, fileRef);
                    this.references.add(refPair);
                }
                break block7;
            }
            if (child.getTagNumWithClass() != 133L) break block7;
            Parser p = new Parser(child);
            this.proprietaryInformation = new ArrayList<TLV>();
            while (p.match(133L)) {
                this.proprietaryInformation.add(p.next(0));
            }
        }
    }

    public String getURL() {
        return this.uniformResourceLocator;
    }

    public byte[] getDiscretionaryData() {
        return this.discretionaryData;
    }

    public byte[] getDiscretionaryDataTemplate() {
        return this.discretionaryDataTemplate;
    }

    public String getApplicationLabel() {
        return this.applicationLabel;
    }

    public byte[] getFileReference() {
        return this.fileReference;
    }

    public List<Pair<byte[], byte[]>> getReferences() {
        return this.references;
    }

    public List<TLV> getProprietaryInformation() {
        return this.proprietaryInformation;
    }

    public boolean hasContent() {
        return this.content;
    }

    public List<ApplicationTemplate> getApplicationTemplates() {
        return this.applicationTemplates;
    }
}

