/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.GenericDataContainerObject;
import org.openecard.common.tlv.iso7816.TLVType;

public class DataContainerObjectChoice
extends TLVType {
    private GenericDataContainerObject<TLV> opaqueDO;
    private GenericDataContainerObject<TLV> iso7816DO;
    private GenericDataContainerObject<TLV> oidDO;
    private TLV extension;

    public DataContainerObjectChoice(TLV tlv) throws TLVException {
        super(tlv);
        Parser p = new Parser(tlv);
        if (p.match(new Tag(TagClass.UNIVERSAL, false, 16L))) {
            this.opaqueDO = new GenericDataContainerObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 0L))) {
            this.iso7816DO = new GenericDataContainerObject<TLV>(p.next(0), TLV.class);
        } else if (p.match(new Tag(TagClass.CONTEXT, false, 1L))) {
            this.oidDO = new GenericDataContainerObject<TLV>(p.next(0), TLV.class);
        } else {
            this.extension = p.next(0);
        }
    }

    public GenericDataContainerObject<TLV> getOpaqueDO() {
        return this.opaqueDO;
    }

    public GenericDataContainerObject<TLV> getIso7816DO() {
        return this.iso7816DO;
    }

    public GenericDataContainerObject<TLV> getOidDO() {
        return this.oidDO;
    }

    public TLV getExtension() {
        return this.extension;
    }
}

