/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.tlv.iso7816;

import org.openecard.common.tlv.Parser;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.Tag;
import org.openecard.common.tlv.TagClass;
import org.openecard.common.tlv.iso7816.TLVType;
import org.openecard.common.util.ByteUtils;

public class CommonAuthenticationObjectAttributes
extends TLVType {
    private byte[] authId = null;
    private Integer authReference = null;
    private Integer securityEnvironmentID = null;

    public CommonAuthenticationObjectAttributes(TLV tlv) {
        super(tlv);
        Parser p = new Parser(tlv.getChild());
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 4L))) {
            this.authId = p.next(0).getValue();
        }
        if (p.match(new Tag(TagClass.UNIVERSAL, true, 2L))) {
            this.authReference = ByteUtils.toInteger(p.next(0).getValue());
        }
        if (p.match(new Tag(TagClass.CONTEXT, true, 0L))) {
            this.securityEnvironmentID = ByteUtils.toInteger(p.next(0).getValue());
        }
    }

    public byte[] getAuthId() {
        return this.authId;
    }

    public int getAuthReference() {
        if (this.authReference != null) {
            return this.authReference;
        }
        return -1;
    }

    public int getSecurityEnvironmentID() {
        if (this.securityEnvironmentID != null) {
            return this.securityEnvironmentID;
        }
        return -1;
    }
}

