/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.util;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.util.Promise;
import org.openecard.gui.StepResult;
import org.openecard.gui.executor.ExecutionResults;
import org.openecard.gui.executor.StepAction;
import org.openecard.gui.executor.StepActionResult;
import org.openecard.gui.executor.StepActionResultStatus;

public class InsertCardStepAction
extends StepAction
implements EventCallback {
    private final Collection<String> cardTypes;
    private final List<ConnectionHandleType> response = new ArrayList<ConnectionHandleType>();
    private final CardStateMap cardStates;
    private final List<ConnectionHandleType> insertableCards;
    private final Promise<ConnectionHandleType> promise = new Promise();

    public InsertCardStepAction(String stepName, CardStateMap cardStates, Collection<String> cardTypes) {
        super(stepName);
        this.cardStates = cardStates;
        this.cardTypes = cardTypes;
        this.insertableCards = this.createHandleList();
    }

    @Override
    public StepActionResult perform(Map<String, ExecutionResults> oldResults, StepResult result) {
        ArrayList<ConnectionHandleType> availableCards = new ArrayList<ConnectionHandleType>();
        availableCards.addAll(this.checkAvailability());
        while (availableCards.isEmpty()) {
            try {
                availableCards.add(this.promise.deref());
            }
            catch (InterruptedException ex) {
                return new StepActionResult(StepActionResultStatus.CANCEL);
            }
            availableCards.addAll(this.checkAvailability());
        }
        this.response.addAll(availableCards);
        return new StepActionResult(StepActionResultStatus.NEXT);
    }

    public List<ConnectionHandleType> getResponse() {
        return this.response;
    }

    @Nonnull
    private List<ConnectionHandleType> createHandleList() {
        ArrayList<ConnectionHandleType> handles = new ArrayList<ConnectionHandleType>();
        for (String type : this.cardTypes) {
            ConnectionHandleType conHandle = new ConnectionHandleType();
            ConnectionHandleType.RecognitionInfo recInfo = new ConnectionHandleType.RecognitionInfo();
            recInfo.setCardType(type);
            conHandle.setRecognitionInfo(recInfo);
            handles.add(conHandle);
        }
        return handles;
    }

    @Nonnull
    private List<ConnectionHandleType> checkAvailability() {
        ArrayList<ConnectionHandleType> available = new ArrayList<ConnectionHandleType>();
        for (ConnectionHandleType conHandle : this.insertableCards) {
            Set<CardStateEntry> entries = this.cardStates.getMatchingEntries(conHandle);
            if (entries.isEmpty()) continue;
            available.add(entries.iterator().next().handleCopy());
        }
        return available;
    }

    @Override
    public void signalEvent(EventType eventType, EventObject eventData) {
        if (eventType == EventType.CARD_RECOGNIZED) {
            ConnectionHandleType handle = eventData.getHandle();
            for (String cardType : this.cardTypes) {
                if (!cardType.equals(handle.getRecognitionInfo().getCardType())) continue;
                this.promise.deliver(handle);
                break;
            }
        }
    }
}

