/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.util;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openecard.common.AppVersion;
import org.openecard.common.I18n;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.interfaces.EventDispatcher;
import org.openecard.common.sal.state.CardStateEntry;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.util.InsertCardStepAction;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.Step;
import org.openecard.gui.definition.Text;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.openecard.gui.executor.StepAction;

public class InsertCardDialog {
    private static final String STEP_ID = "insert-card";
    private final I18n lang = I18n.getTranslation("tctoken");
    private final UserConsent gui;
    private final Map<String, String> cardNameAndType;
    private final CardStateMap cardStates;
    private final EventDispatcher evDispatcher;

    public InsertCardDialog(UserConsent gui, CardStateMap cardStates, Map<String, String> cardNameAndType, EventDispatcher manager) {
        this.gui = gui;
        this.cardNameAndType = cardNameAndType;
        this.cardStates = cardStates;
        this.evDispatcher = manager;
    }

    public List<ConnectionHandleType> show() {
        List<ConnectionHandleType> availableCards = this.checkAlreadyAvailable();
        if (!availableCards.isEmpty()) {
            return availableCards;
        }
        InsertCardStepAction insertCardAction = new InsertCardStepAction(STEP_ID, this.cardStates, this.cardNameAndType.values());
        this.evDispatcher.add((EventCallback)insertCardAction, EventType.CARD_RECOGNIZED);
        UserConsentNavigator ucr = this.gui.obtainNavigator(this.createInsertCardUserConsent(insertCardAction));
        ExecutionEngine exec = new ExecutionEngine(ucr);
        ResultStatus status = exec.process();
        if (status == ResultStatus.CANCEL) {
            return null;
        }
        this.evDispatcher.del(insertCardAction);
        return insertCardAction.getResponse();
    }

    private List<ConnectionHandleType> checkAlreadyAvailable() {
        ArrayList<ConnectionHandleType> handlesList = new ArrayList<ConnectionHandleType>();
        for (String type : this.cardNameAndType.values()) {
            ConnectionHandleType conHandle = new ConnectionHandleType();
            ConnectionHandleType.RecognitionInfo recInfo = new ConnectionHandleType.RecognitionInfo();
            recInfo.setCardType(type);
            conHandle.setRecognitionInfo(recInfo);
            Set<CardStateEntry> entries = this.cardStates.getMatchingEntries(conHandle);
            if (entries.isEmpty()) continue;
            handlesList.add(entries.iterator().next().handleCopy());
        }
        return handlesList;
    }

    private UserConsentDescription createInsertCardUserConsent(StepAction insertCardAction) {
        UserConsentDescription uc = new UserConsentDescription(this.lang.translationForKey("title", AppVersion.getName()));
        Step s = new Step(STEP_ID, this.lang.translationForKey("step.title", new Object[0]));
        s.setInstantReturn(true);
        s.setAction(insertCardAction);
        Text i1 = new Text();
        if (this.cardNameAndType.size() == 1) {
            i1.setText(this.lang.translationForKey("step.message.singletype", new Object[0]));
        } else {
            i1.setText(this.lang.translationForKey("step.message.multipletypes", new Object[0]));
        }
        s.getInputInfoUnits().add(i1);
        for (String key : this.cardNameAndType.keySet()) {
            Text item = new Text(" - " + key);
            s.getInputInfoUnits().add(item);
        }
        uc.getSteps().add(s);
        return uc;
    }
}

