/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.sal.state;

import iso.std.iso_iec._24727.tech.schema.CardInfoType;
import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import org.openecard.addon.sal.CredentialManager;
import org.openecard.common.event.EventObject;
import org.openecard.common.event.EventType;
import org.openecard.common.event.IfdEventObject;
import org.openecard.common.interfaces.Environment;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.sal.state.CardStateMap;
import org.openecard.common.sal.state.HandlePrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SALStateCallback
implements EventCallback {
    private static final Logger LOG = LoggerFactory.getLogger(SALStateCallback.class);
    private final Environment env;
    private final CredentialManager manager;

    public SALStateCallback(Environment env, CardStateMap cardState) {
        this.env = env;
        this.manager = new CredentialManager(cardState);
    }

    @Override
    public void signalEvent(EventType eventType, EventObject eventData) {
        if (eventData instanceof IfdEventObject) {
            IfdEventObject ifdEvtData = (IfdEventObject)eventData;
            ConnectionHandleType handle = ifdEvtData.getHandle();
            switch (eventType) {
                case CARD_RECOGNIZED: {
                    LOG.info("Add ConnectionHandle to SAL:\n{}", (Object)HandlePrinter.printHandle(handle));
                    String cardType = handle.getRecognitionInfo().getCardType();
                    CardInfoType cif = this.env.getCIFProvider().getCardInfo(handle, cardType);
                    if (cif != null) {
                        this.manager.addCredential(handle, ifdEvtData.getIfaceProtocol(), cif);
                        break;
                    }
                    LOG.info("Not adding card to SAL, because it has no CardInfo file.");
                    break;
                }
                case CARD_REMOVED: {
                    LOG.info("Remove ConnectionHandle from SAL.\n{}", (Object)HandlePrinter.printHandle(handle));
                    this.manager.removeCredential(handle);
                    break;
                }
            }
        }
    }
}

