/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.ifd.scio;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.openecard.common.ifd.scio.SCIOException;
import org.openecard.common.ifd.scio.SCIOTerminals;
import org.openecard.common.ifd.scio.TerminalState;

public interface TerminalWatcher {
    @Nonnull
    public SCIOTerminals getTerminals();

    public List<TerminalState> start() throws SCIOException;

    @Nonnull
    public StateChangeEvent waitForChange(long var1) throws SCIOException;

    @Nonnull
    public StateChangeEvent waitForChange() throws SCIOException;

    @Immutable
    public static final class StateChangeEvent {
        private final EventType type;
        private final String terminal;

        public StateChangeEvent(@Nonnull EventType type, @Nonnull String terminal) {
            if (type == null || terminal == null) {
                throw new IllegalArgumentException("Attempt to create invalid StateChangeEvent instance.");
            }
            this.type = type;
            this.terminal = terminal;
        }

        public StateChangeEvent() {
            this.type = null;
            this.terminal = null;
        }

        public boolean isCancelled() {
            return this.type == null;
        }

        @Nonnull
        public EventType getState() {
            if (this.isCancelled()) {
                throw new IllegalStateException("State requested for cancelled event.");
            }
            return this.type;
        }

        public String getTerminal() {
            if (this.isCancelled()) {
                throw new IllegalStateException("Terminal requested for cancelled event.");
            }
            return this.terminal;
        }
    }

    public static enum EventType {
        TERMINAL_ADDED,
        TERMINAL_REMOVED,
        CARD_INSERTED,
        CARD_REMOVED;

    }
}

