/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.common;

import javax.annotation.Nonnull;
import org.openecard.common.apdu.common.APDUTemplateException;
import org.openecard.common.apdu.common.APDUTemplateFunction;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.StringUtils;

public class TLVFunction
implements APDUTemplateFunction {
    @Override
    @Nonnull
    public String call(Object ... params) throws APDUTemplateException {
        if (params.length != 2) {
            throw new APDUTemplateException("Invalid number of parameters given. Two are needed.");
        }
        byte[] tag = this.makeBytes(params[0]);
        byte[] value = this.makeBytes(params[1]);
        try {
            TLV tlv = new TLV();
            tlv.setTagNumWithClass(tag);
            tlv.setValue(value);
            byte[] result = tlv.toBER();
            String resultStr = ByteUtils.toHexString(result);
            return resultStr;
        }
        catch (TLVException ex) {
            throw new APDUTemplateException("Failed to create TLV structure based on given parameters.", ex);
        }
    }

    private byte[] makeBytes(Object o) {
        if (o instanceof String) {
            return StringUtils.toByteArray((String)o, true);
        }
        return (byte[])o;
    }
}

