/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu.common;

import iso.std.iso_iec._24727.tech.schema.InputAPDUInfoType;
import iso.std.iso_iec._24727.tech.schema.Transmit;
import iso.std.iso_iec._24727.tech.schema.TransmitResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openecard.common.WSHelper;
import org.openecard.common.apdu.common.CardAPDU;
import org.openecard.common.apdu.common.CardCommandStatus;
import org.openecard.common.apdu.common.CardResponseAPDU;
import org.openecard.common.apdu.exception.APDUException;
import org.openecard.common.interfaces.Dispatcher;
import org.openecard.common.util.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardCommandAPDU
extends CardAPDU {
    private static final Logger logger = LoggerFactory.getLogger(CardCommandAPDU.class);
    private final byte[] header = new byte[4];
    private int le = -1;
    private int lc = -1;

    protected CardCommandAPDU() {
    }

    public CardCommandAPDU(byte[] commandAPDU) {
        System.arraycopy(commandAPDU, 0, this.header, 0, 4);
        this.setBody(ByteUtils.copy(commandAPDU, 4, commandAPDU.length - 4));
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2) {
        this.header[0] = cla;
        this.header[1] = ins;
        this.header[2] = p1;
        this.header[3] = p2;
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte le) {
        this(cla, ins, p1, p2, le & 0xFF);
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, short le) {
        this(cla, ins, p1, p2, le & 0xFFFF);
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, int le) {
        this(cla, ins, p1, p2);
        this.le = le;
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data) {
        this(cla, ins, p1, p2);
        this.data = data;
        this.setLC(data.length);
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data, byte le) {
        this(cla, ins, p1, p2, data, le & 0xFF);
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data, short le) {
        this(cla, ins, p1, p2, data, le & 0xFFFF);
    }

    public CardCommandAPDU(byte cla, byte ins, byte p1, byte p2, byte[] data, int le) {
        this(cla, ins, p1, p2, data);
        this.setLE(le);
    }

    protected void setCLA(byte cla) {
        this.header[0] = cla;
    }

    public byte getCLA() {
        return (byte)(this.header[0] & 0xFF);
    }

    protected void setINS(byte ins) {
        this.header[1] = ins;
    }

    public byte getINS() {
        return (byte)(this.header[1] & 0xFF);
    }

    protected void setP1(byte p1) {
        this.header[2] = p1;
    }

    public byte getP1() {
        return (byte)(this.header[2] & 0xFF);
    }

    protected void setP2(byte p2) {
        this.header[3] = p2;
    }

    public byte getP2() {
        return (byte)(this.header[3] & 0xFF);
    }

    protected void setP1P2(byte[] p1p2) {
        this.setP1(p1p2[0]);
        this.setP2(p1p2[1]);
    }

    public byte[] getP1P2() {
        return new byte[]{this.getP1(), this.getP2()};
    }

    public byte[] getHeader() {
        return this.header;
    }

    public static byte[] getHeader(byte[] commandAPDU) {
        if (commandAPDU.length < 4) {
            throw new IllegalArgumentException("Malformed APDU");
        }
        return ByteUtils.copy(commandAPDU, 0, 4);
    }

    protected final void setLC(byte lc) {
        this.setLC(lc & 0xFF);
    }

    protected final void setLC(short lc) {
        this.setLC(lc & 0xFFFF);
    }

    protected final void setLC(int lc) {
        if (lc < 1 || lc > 65536) {
            throw new IllegalArgumentException("Length should be from '1' to '65535'.");
        }
        this.lc = lc;
    }

    public int getLC() {
        return this.lc;
    }

    @Override
    public void setData(byte[] data) {
        super.setData(data);
        this.setLC(data.length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void setBody(byte[] body) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(body);
            int length = bais.available();
            this.lc = -1;
            this.le = -1;
            this.data = new byte[0];
            if (length == 0) return;
            if (length == 1) {
                this.le = bais.read() & 0xFF;
                return;
            } else {
                if (length >= 65536) throw new IllegalArgumentException("Malformed APDU.");
                int tmp = bais.read();
                if (tmp == 0) {
                    if (bais.available() < 3) {
                        this.le = (bais.read() & 0xFF) << 8 | bais.read() & 0xFF;
                        return;
                    } else {
                        this.lc = (bais.read() & 0xFF) << 8 | bais.read() & 0xFF;
                        this.data = new byte[this.lc];
                        bais.read(this.data);
                        if (bais.available() == 1) {
                            this.le = bais.read() & 0xFF;
                            return;
                        } else if (bais.available() == 2) {
                            this.le = (bais.read() & 0xFF) << 8 | bais.read() & 0xFF;
                            return;
                        } else if (bais.available() == 3) {
                            if (bais.read() != 0) throw new IllegalArgumentException("Malformed APDU.");
                            this.le = (bais.read() & 0xFF) << 8 | bais.read() & 0xFF;
                            return;
                        } else {
                            if (bais.available() <= 3) return;
                            throw new IllegalArgumentException("Malformed APDU.");
                        }
                    }
                } else {
                    if (tmp <= 0) throw new IllegalArgumentException("Malformed APDU.");
                    this.lc = tmp & 0xFF;
                    this.data = new byte[this.lc];
                    bais.read(this.data);
                    if (bais.available() == 1 || bais.available() == 3) {
                        tmp = bais.read();
                        this.le = tmp != 0 ? tmp & 0xFF : (bais.read() & 0xFF) << 8 | bais.read() & 0xFF;
                        return;
                    } else {
                        if (bais.available() != 2 && bais.available() <= 3) return;
                        throw new IllegalArgumentException("Malformed APDU.");
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Exception", e);
        }
    }

    public static byte[] getBody(byte[] commandAPDU) {
        if (commandAPDU.length < 4) {
            throw new IllegalArgumentException("Malformed APDU");
        }
        return ByteUtils.copy(commandAPDU, 4, commandAPDU.length - 4);
    }

    public final void setLE(byte le) {
        if (le == 0) {
            this.setLE(256);
        } else {
            this.setLE(le & 0xFF);
        }
    }

    public final void setLE(short le) {
        if (le == 0) {
            this.setLE(65536);
        } else {
            this.setLE(le & 0xFFFF);
        }
    }

    public final void setLE(int le) {
        if (le < 0 || le > 65536) {
            throw new IllegalArgumentException("Length should be from '1' to '65535'.");
        }
        this.le = le;
    }

    public final int getLE() {
        return this.le;
    }

    public final void setChaining() {
        this.header[0] = (byte)(this.header[0] | 0x10);
    }

    public final Iterable getChainingIterator() {
        throw new IllegalAccessError("Not implemented yet");
    }

    public final void setSecureMessaging() {
        this.header[0] = (byte)(this.header[0] | 0xC);
    }

    public final boolean isSecureMessaging() {
        return (this.header[0] & 0xF) == 12;
    }

    public final byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(this.header);
            if (this.lc > 255 || this.le > 256 && this.lc > 0) {
                baos.write(0);
                baos.write((byte)(this.lc >> 8));
                baos.write((byte)this.lc);
            } else if (this.lc > 0) {
                baos.write((byte)this.lc);
            }
            baos.write(this.data);
            if (this.le > 256) {
                if (this.lc == 0 || this.lc == -1) {
                    baos.write(0);
                }
                if (this.le >= 65536) {
                    baos.write(0);
                    baos.write(0);
                } else {
                    baos.write((byte)(this.le >> 8));
                    baos.write((byte)this.le);
                }
            } else if (this.le > 0) {
                if (this.lc > 255) {
                    baos.write((byte)(this.le >> 8));
                    baos.write((byte)this.le);
                } else {
                    baos.write((byte)this.le);
                }
            }
        }
        catch (IOException ex) {
            logger.error("Failed to create APDU in memory.", ex);
        }
        return baos.toByteArray();
    }

    public String toHexString() {
        return ByteUtils.toHexString(this.toByteArray());
    }

    public String toString() {
        return ByteUtils.toHexString(this.toByteArray(), true);
    }

    public Transmit makeTransmit(byte[] slotHandle) {
        return this.makeTransmit(slotHandle, new ArrayList<byte[]>(0));
    }

    public Transmit makeTransmit(byte[] slotHandle, List<byte[]> responses) {
        InputAPDUInfoType apdu = new InputAPDUInfoType();
        apdu.setInputAPDU(this.toByteArray());
        apdu.getAcceptableStatusCode().addAll(responses);
        Transmit t = new Transmit();
        t.setSlotHandle(slotHandle);
        t.getInputAPDUInfo().add(apdu);
        return t;
    }

    public CardResponseAPDU transmit(Dispatcher dispatcher, byte[] slotHandle) throws APDUException {
        return this.transmit(dispatcher, slotHandle, CardCommandStatus.responseOk());
    }

    public CardResponseAPDU transmit(Dispatcher dispatcher, byte[] slotHandle, List<byte[]> responses) throws APDUException {
        TransmitResponse tr = null;
        try {
            Transmit t = responses != null ? this.makeTransmit(slotHandle, responses) : this.makeTransmit(slotHandle);
            tr = (TransmitResponse)dispatcher.safeDeliver(t);
            WSHelper.checkResult(tr);
            CardResponseAPDU responseAPDU = new CardResponseAPDU(tr);
            return responseAPDU;
        }
        catch (WSHelper.WSException ex) {
            throw new APDUException(ex, tr);
        }
        catch (Exception ex) {
            throw new APDUException(ex);
        }
    }
}

