/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import java.util.List;
import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.tlv.TLV;
import org.openecard.common.tlv.TLVException;

public class UpdateBinary
extends CardCommandAPDU {
    private static final byte UPDATE_BINARY_INS_DATA = -42;
    private static final byte UPDATE_BINARY_INS_OFFSET_AND_DISCRETIONARY_DATA = -41;

    public UpdateBinary(byte p1, byte p2, byte[] dataUnitsToUpdate) {
        super((byte)0, (byte)-42, p1, p2, dataUnitsToUpdate);
    }

    public UpdateBinary(byte p1, byte p2, TLV offsetDiscretionaryData) throws TLVException {
        List<TLV> data = offsetDiscretionaryData.asList();
        if (data.size() > 2) {
            throw new IllegalArgumentException("Wrong number of objects.");
        }
        if (data.get(0).getTagNumWithClass() != 84L) {
            throw new IllegalArgumentException("The tag for the offset data object is wrong.");
        }
        if (data.get(1).getTagNumWithClass() != 83L && data.get(1).getTagNumWithClass() != 115L) {
            throw new IllegalArgumentException("The discretionary data object does not start with the correct tag.");
        }
        this.setCLA((byte)0);
        this.setINS((byte)-41);
        this.setP1(p1);
        this.setP2(p2);
        this.setData(offsetDiscretionaryData.toBER());
        this.setLC(offsetDiscretionaryData.toBER().length);
    }
}

