/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.apdu;

import org.openecard.common.apdu.common.CardCommandAPDU;
import org.openecard.common.util.ShortUtils;

public class DeleteFile
extends CardCommandAPDU {
    private static final byte INS_DELETE_FILE = -28;
    private static final byte FCI = 0;
    private static final byte FCP = 4;
    private static final byte FMD = 8;

    public DeleteFile(byte p1, byte p2) {
        super((byte)0, (byte)-28, p1, p2);
    }

    public void setFCI() {
        this.setP2((byte)0);
    }

    public void setFCP() {
        this.setP2((byte)4);
    }

    public void setFMD() {
        this.setP2((byte)8);
    }

    public static final class RelativePath
    extends DeleteFile {
        public RelativePath(byte[] aid) {
            super((byte)9, (byte)12);
            this.setData(aid);
        }
    }

    public static final class AbsolutePath
    extends DeleteFile {
        public AbsolutePath(byte[] aid) {
            super((byte)8, (byte)12);
            this.setData(aid);
        }
    }

    public static final class Application
    extends DeleteFile {
        public Application(byte[] aid) {
            super((byte)4, (byte)12);
            this.setData(aid);
        }
    }

    public static final class Parent
    extends DeleteFile {
        public Parent() {
            super((byte)3, (byte)12);
        }
    }

    public static final class ChildFile
    extends DeleteFile {
        public ChildFile(byte[] fid) {
            super((byte)2, (byte)12);
            this.setData(fid);
        }

        public ChildFile(short fid) {
            this(ShortUtils.toByteArray(fid));
        }
    }

    public static final class ChildDirectory
    extends DeleteFile {
        public ChildDirectory(byte[] fid) {
            super((byte)1, (byte)12);
            this.setData(fid);
        }
    }

    public static final class File
    extends DeleteFile {
        public File(byte[] fid) {
            super((byte)0, (byte)12);
            this.setData(fid);
        }
    }

    public static final class MasterFile
    extends DeleteFile {
        public static final byte[] MF_FID = new byte[]{63, 0};

        public MasterFile() {
            super((byte)0, (byte)12);
            this.setData(MF_FID);
        }
    }
}

