/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common.anytype.pin;

import iso.std.iso_iec._24727.tech.schema.DIDAuthenticationDataType;
import iso.std.iso_iec._24727.tech.schema.PinCompareDIDAuthenticateOutputType;
import java.math.BigInteger;
import javax.xml.parsers.ParserConfigurationException;
import org.openecard.common.anytype.AuthDataMap;
import org.openecard.common.anytype.AuthDataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PINCompareDIDAuthenticateOutputType {
    private static final Logger LOG = LoggerFactory.getLogger(PINCompareDIDAuthenticateOutputType.class);
    private static final String ISO_NS = "urn:iso:std:iso-iec:24727:tech:schema";
    private final AuthDataMap authMap;
    private BigInteger retryCounter;

    public PINCompareDIDAuthenticateOutputType(DIDAuthenticationDataType data) throws ParserConfigurationException {
        this.authMap = new AuthDataMap(data);
        String retryCounterStr = this.authMap.getContentAsString(ISO_NS, "RetryCounter");
        if (retryCounterStr != null) {
            try {
                this.retryCounter = new BigInteger(retryCounterStr);
            }
            catch (NumberFormatException ex) {
                LOG.warn("Can not convert malformed RetryCounter value to an integer.", ex);
            }
        }
    }

    protected PINCompareDIDAuthenticateOutputType(AuthDataMap authMap) {
        this.authMap = authMap;
    }

    public BigInteger getRetryCounter() {
        return this.retryCounter;
    }

    public void setRetryCounter(BigInteger retryCounter) {
        this.retryCounter = retryCounter;
    }

    public PinCompareDIDAuthenticateOutputType getAuthDataType() {
        PinCompareDIDAuthenticateOutputType pinCompareOutput = new PinCompareDIDAuthenticateOutputType();
        AuthDataResponse<PinCompareDIDAuthenticateOutputType> authResponse = this.authMap.createResponse(pinCompareOutput);
        if (this.retryCounter != null) {
            authResponse.addElement(ISO_NS, "RetryCounter", this.retryCounter.toString());
        }
        return authResponse.getResponse();
    }
}

