/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Version {
    private static final String UNKNOWN_NAME = "UNKNOWN";
    private static final String UNKNOWN_VERSION = "UNKNOWN";
    private final String version;
    private final String name;
    private final String specName;
    private final ArrayList<String> specVersions;
    private final int major;
    private final int minor;
    private final int patch;
    private final String buildId;

    public Version(@Nullable String name, @Nullable String ver, @Nullable String specName, @Nullable String specVer) {
        this.specName = this.fixName(specName);
        this.specVersions = Version.loadVersionLine(specVer);
        this.name = this.fixName(name);
        this.version = Version.loadVersionLine(ver).get(0);
        String[] groups = this.splitVersion(this.version);
        this.major = Integer.parseInt(groups[0]);
        this.minor = Integer.parseInt(groups[1]);
        this.patch = Integer.parseInt(groups[2]);
        this.buildId = groups[3];
    }

    private String fixName(String name) {
        return name == null ? "UNKNOWN" : name;
    }

    private static ArrayList<String> loadVersionLine(String in) {
        ArrayList<String> versions = new ArrayList<String>();
        if (in == null) {
            versions.add("UNKNOWN");
        } else {
            BufferedReader r = new BufferedReader(new StringReader(in));
            try {
                String line = r.readLine();
                do {
                    if (line == null) {
                        versions.add("UNKNOWN");
                        continue;
                    }
                    versions.add(line);
                } while ((line = r.readLine()) != null);
            }
            catch (IOException ex) {
                versions.clear();
                versions.add("UNKNOWN");
            }
        }
        return versions;
    }

    private String[] splitVersion(String version) {
        String[] groups = new String[4];
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(-.+)?");
        Matcher m = p.matcher(version);
        if (m.matches() && m.groupCount() >= 3) {
            groups[0] = m.group(1);
            groups[1] = m.group(2);
            groups[2] = m.group(3);
            groups[3] = m.group(4);
            if (groups[3] != null) {
                groups[3] = groups[3].substring(1);
            }
        } else {
            groups[0] = "0";
            groups[1] = "0";
            groups[2] = "0";
            groups[3] = null;
        }
        return groups;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getBuildId() {
        return this.buildId;
    }

    public boolean isNewer(@Nonnull Version v) {
        if ("UNKNOWN".equals(this.getVersion()) && "UNKNOWN".equals(v.getVersion())) {
            return false;
        }
        if (this.getVersion().equals(v.getVersion())) {
            return false;
        }
        if ("UNKNOWN".equals(this.getVersion())) {
            return false;
        }
        if ("UNKNOWN".equals(v.getVersion())) {
            return true;
        }
        if (this.getMajor() > v.getMajor()) {
            return true;
        }
        if (this.getMajor() < v.getMajor()) {
            return false;
        }
        if (this.getMinor() > v.getMinor()) {
            return true;
        }
        if (this.getMinor() < v.getMinor()) {
            return false;
        }
        if (this.getPatch() > v.getPatch()) {
            return true;
        }
        if (this.getPatch() < v.getPatch()) {
            return false;
        }
        if (this.getBuildId() == null && v.getBuildId() == null) {
            return false;
        }
        if (this.getBuildId() == null && v.getBuildId() != null) {
            return true;
        }
        if (this.getBuildId() != null && v.getBuildId() == null) {
            return false;
        }
        return this.getBuildId().compareTo(v.getBuildId()) < 0;
    }

    public boolean isOlder(@Nonnull Version v) {
        return v.isNewer(this);
    }

    public boolean isSame(@Nonnull Version v) {
        return !this.isNewer(v) && !v.isNewer(this);
    }

    public String getSpecName() {
        return this.specName;
    }

    public List<String> getSpecVersions() {
        return Collections.unmodifiableList(this.specVersions);
    }

    public String getLatestSpecVersion() {
        return this.specVersions.get(this.specVersions.size() - 1);
    }
}

