/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import javax.annotation.Nonnull;
import org.openecard.common.I18nKey;
import org.openecard.common.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18n {
    private static final Logger logger = LoggerFactory.getLogger(I18n.class);
    private static final ConcurrentSkipListMap<String, I18n> translations = new ConcurrentSkipListMap();
    private final Class<?> loaderReference;
    private final String component;
    private final Properties translation;
    private final Properties original;
    private final TreeMap<String, URL> translatedFiles;

    public static I18n getTranslation(String component) {
        return I18n.getTranslation(I18n.class, component);
    }

    public static synchronized I18n getTranslation(Class<?> loaderReference, String component) {
        if (translations.containsKey(component)) {
            return translations.get(component);
        }
        I18n t = new I18n(loaderReference, component);
        translations.put(component, t);
        return t;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }

    private I18n(Class<?> loaderReference, String component) {
        Properties target;
        this.loaderReference = loaderReference;
        Locale userLocale = I18n.getLocale();
        String lang = userLocale.getLanguage();
        String country = userLocale.getCountry();
        Properties defaults = this.loadFile(component, "C");
        this.original = (Properties)defaults.clone();
        if (!lang.isEmpty()) {
            target = this.loadFile(component, lang);
            defaults = I18n.mergeProperties(defaults, target);
        }
        if (!lang.isEmpty() && !country.isEmpty()) {
            target = this.loadFile(component, lang + "_" + country);
            defaults = I18n.mergeProperties(defaults, target);
        }
        this.component = component;
        this.translation = defaults;
        this.translatedFiles = new TreeMap();
    }

    private Properties loadFile(String component, String locale) {
        try {
            String fileName = "/openecard_i18n/" + component + "/Messages_" + locale + ".properties";
            InputStream in = FileUtils.resolveResourceAsStream(this.loaderReference, fileName);
            Properties props = new Properties();
            InputStreamReader r = new InputStreamReader(in, "utf-8");
            props.load(r);
            return props;
        }
        catch (IOException | RuntimeException ex) {
            logger.warn("Failed to load resource {} for lang {}.", (Object)component, (Object)locale);
            return new Properties();
        }
    }

    private static Properties mergeProperties(Properties defaults, Properties target) {
        Properties result = new Properties(defaults);
        result.putAll((Map<?, ?>)target);
        return result;
    }

    public String associatedComponent() {
        return this.component;
    }

    public String translationForKey(String key, Object ... parameters) {
        String result = this.translation.getProperty(key.toLowerCase());
        if (result == null) {
            return "<<No translation for key <" + key + ">>";
        }
        if (parameters.length != 0) {
            String formattedResult = String.format(result, parameters);
            return formattedResult;
        }
        return result;
    }

    public String translationForKey(I18nKey key, Object ... parameters) {
        return this.translationForKey(key.getKey(), parameters);
    }

    @Nonnull
    public URL translationForFile(String name) throws IOException {
        return this.translationForFile(name, null);
    }

    @Nonnull
    public synchronized URL translationForFile(String name, String fileEnding) throws IOException {
        String fileName;
        URL url;
        fileEnding = fileEnding != null ? "." + fileEnding : "";
        String mapKey = name + fileEnding;
        if (this.translatedFiles.containsKey(mapKey)) {
            URL url2 = this.translatedFiles.get(mapKey);
            if (url2 == null) {
                throw new IOException("No translation available for file '" + name + fileEnding + "'.");
            }
            return url2;
        }
        Locale locale = Locale.getDefault();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        String fnameBase = "/openecard_i18n/" + this.component + "/" + name;
        if (!lang.isEmpty() && !country.isEmpty() && (url = FileUtils.resolveResourceAsURL(this.loaderReference, fileName = fnameBase + "_" + lang + "_" + country + fileEnding)) != null) {
            this.translatedFiles.put(mapKey, url);
            return url;
        }
        if (!lang.isEmpty() && (url = FileUtils.resolveResourceAsURL(this.loaderReference, fileName = fnameBase + "_" + lang + fileEnding)) != null) {
            this.translatedFiles.put(mapKey, url);
            return url;
        }
        fileName = fnameBase + "_C" + fileEnding;
        url = FileUtils.resolveResourceAsURL(this.loaderReference, fileName);
        if (url != null) {
            this.translatedFiles.put(mapKey, url);
            return url;
        }
        this.translatedFiles.put(mapKey, null);
        throw new IOException("No translation available for file '" + name + fileEnding + "'.");
    }

    public String getOriginalMessage(String key, Object ... parameters) {
        String result = this.original.getProperty(key.toLowerCase());
        if (result == null) {
            return "<<No translation for key <" + key + ">>";
        }
        if (parameters.length != 0) {
            String formattedResult = String.format(result, parameters);
            return formattedResult;
        }
        return result;
    }

    public String getOriginalMessage(I18nKey key, Object ... parameters) {
        return this.getOriginalMessage(key.getKey(), parameters);
    }

    static {
        I18n.getTranslation("ifd");
        I18n.getTranslation("sal");
    }
}

