/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.openecard.common.Version;
import org.openecard.common.util.FileUtils;

public class AppVersion {
    private static final String APPNAME_FILE = "openecard/APPNAME";
    private static final String APPVERSION_FILE = "openecard/VERSION";
    private static final String SPECNAME_FILE = "openecard/EID_CLIENT_SPECIFICATION";
    private static final String SPECVERSION_FILE = "openecard/SUPPORTED_EID_CLIENT_SPEC_VERSIONS";
    private static final Version INST;

    private static String readStream(InputStream in) {
        if (in == null) {
            return null;
        }
        Scanner s = new Scanner(in, "UTF-8").useDelimiter("\\A");
        try {
            String nameStr = s.next();
            return nameStr.trim();
        }
        catch (NoSuchElementException ex) {
            return null;
        }
    }

    public static String getName() {
        return INST.getName();
    }

    public static String getVersion() {
        return INST.getVersion();
    }

    public static int getMajor() {
        return INST.getMajor();
    }

    public static int getMinor() {
        return INST.getMinor();
    }

    public static int getPatch() {
        return INST.getPatch();
    }

    public static String getBuildId() {
        return INST.getBuildId();
    }

    public static String getSpecName() {
        return INST.getSpecName();
    }

    public static List<String> getSpecVersions() {
        return INST.getSpecVersions();
    }

    public static String getLatestSpecVersion() {
        return INST.getLatestSpecVersion();
    }

    static {
        InputStream inSpecVer;
        InputStream inSpecName;
        InputStream inVer;
        InputStream inName;
        try {
            inName = FileUtils.resolveResourceAsStream(AppVersion.class, APPNAME_FILE);
        }
        catch (IOException ex) {
            inName = null;
        }
        String name = AppVersion.readStream(inName);
        try {
            inVer = FileUtils.resolveResourceAsStream(AppVersion.class, APPVERSION_FILE);
        }
        catch (IOException ex) {
            inVer = null;
        }
        String ver = AppVersion.readStream(inVer);
        try {
            inSpecName = FileUtils.resolveResourceAsStream(AppVersion.class, SPECNAME_FILE);
        }
        catch (IOException ex) {
            inSpecName = null;
        }
        String specName = AppVersion.readStream(inSpecName);
        try {
            inSpecVer = FileUtils.resolveResourceAsStream(AppVersion.class, SPECVERSION_FILE);
        }
        catch (IOException ex) {
            inSpecVer = null;
        }
        String specVer = AppVersion.readStream(inSpecVer);
        INST = new Version(name, ver, specName, specVer);
    }
}

