/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl.jcajce;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.openecard.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.openecard.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.openecard.bouncycastle.tls.crypto.TlsSigner;
import org.openecard.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import org.openecard.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import org.openecard.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;

public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        TlsSigner signer;
        if (privateKey instanceof RSAPrivateKey || "RSA".equals(privateKey.getAlgorithm())) {
            signer = new JcaTlsRSASigner(crypto, privateKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equals(privateKey.getAlgorithm())) {
            signer = new JcaTlsDSASigner(crypto, privateKey);
        } else if (privateKey instanceof ECPrivateKey || "EC".equals(privateKey.getAlgorithm())) {
            signer = new JcaTlsECDSASigner(crypto, privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, JcaDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

