/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl.bc;

import org.openecard.bouncycastle.crypto.Digest;
import org.openecard.bouncycastle.crypto.macs.HMac;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsSecret;
import org.openecard.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.openecard.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.openecard.bouncycastle.util.Arrays;
import org.openecard.bouncycastle.util.Strings;

public class BcTlsSecret
extends AbstractTlsSecret {
    protected final BcTlsCrypto crypto;

    public BcTlsSecret(BcTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        byte[] labelSeed = Arrays.concatenate(Strings.toByteArray(label), seed);
        byte[] result = prfAlgorithm == 0 ? this.prf_1_0(this.data, labelSeed, length) : this.prf_1_2(prfAlgorithm, this.data, labelSeed, length);
        return this.crypto.adoptLocalSecret(result);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(Digest digest, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) {
        HMac mac = new HMac(digest);
        mac.init(new KeyParameter(secret, secretOff, secretLen));
        byte[] a = seed;
        int macSize = mac.getMacSize();
        byte[] b1 = new byte[macSize];
        byte[] b2 = new byte[macSize];
        for (int pos = 0; pos < output.length; pos += macSize) {
            mac.update(a, 0, a.length);
            mac.doFinal(b1, 0);
            a = b1;
            mac.update(a, 0, a.length);
            mac.update(seed, 0, seed.length);
            mac.doFinal(b2, 0);
            System.arraycopy(b2, 0, output, pos, Math.min(macSize, output.length - pos));
        }
    }

    protected byte[] prf_1_0(byte[] secret, byte[] labelSeed, int length) {
        int s_half = (secret.length + 1) / 2;
        byte[] b1 = new byte[length];
        this.hmacHash(this.crypto.createDigest((short)1), secret, 0, s_half, labelSeed, b1);
        byte[] b2 = new byte[length];
        this.hmacHash(this.crypto.createDigest((short)2), secret, secret.length - s_half, s_half, labelSeed, b2);
        for (int i = 0; i < length; ++i) {
            int n = i;
            b1[n] = (byte)(b1[n] ^ b2[i]);
        }
        return b1;
    }

    protected byte[] prf_1_2(int prfAlgorithm, byte[] secret, byte[] labelSeed, int length) {
        Digest digest = this.crypto.createDigest(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        byte[] result = new byte[length];
        this.hmacHash(digest, secret, 0, secret.length, labelSeed, result);
        return result;
    }
}

