/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import org.openecard.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.openecard.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.openecard.bouncycastle.crypto.params.DHPublicKeyParameters;
import org.openecard.bouncycastle.tls.crypto.TlsAgreement;
import org.openecard.bouncycastle.tls.crypto.TlsSecret;
import org.openecard.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;

public class BcTlsDH
implements TlsAgreement {
    protected final BcTlsDHDomain domain;
    protected AsymmetricCipherKeyPair localKeyPair;
    protected DHPublicKeyParameters peerPublicKey;

    public BcTlsDH(BcTlsDHDomain domain) {
        this.domain = domain;
    }

    @Override
    public byte[] generateEphemeral() throws IOException {
        this.localKeyPair = this.domain.generateKeyPair();
        return this.domain.encodePublicKey((DHPublicKeyParameters)this.localKeyPair.getPublic());
    }

    @Override
    public void receivePeerValue(byte[] peerValue) throws IOException {
        this.peerPublicKey = this.domain.decodePublicKey(peerValue);
    }

    @Override
    public TlsSecret calculateSecret() throws IOException {
        return this.domain.calculateDHAgreement((DHPrivateKeyParameters)this.localKeyPair.getPrivate(), this.peerPublicKey);
    }
}

