/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.openecard.bouncycastle.tls.TlsDHConfigVerifier;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.DHGroup;
import org.openecard.bouncycastle.tls.crypto.DHStandardGroups;
import org.openecard.bouncycastle.tls.crypto.TlsDHConfig;
import org.openecard.bouncycastle.util.BigIntegers;

public class TlsDHUtils {
    public static boolean containsDHECipherSuites(int[] cipherSuites) {
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (!TlsDHUtils.isDHECipherSuite(cipherSuites[i])) continue;
            return true;
        }
        return false;
    }

    public static DHGroup getDHGroup(TlsDHConfig dhConfig) {
        int namedGroup = dhConfig.getNamedGroup();
        if (namedGroup >= 0) {
            return TlsDHUtils.getNamedDHGroup(namedGroup);
        }
        return dhConfig.getExplicitGroup();
    }

    public static DHGroup getNamedDHGroup(int namedGroup) {
        switch (namedGroup) {
            case 256: {
                return DHStandardGroups.rfc7919_ffdhe2048;
            }
            case 257: {
                return DHStandardGroups.rfc7919_ffdhe3072;
            }
            case 258: {
                return DHStandardGroups.rfc7919_ffdhe4096;
            }
            case 259: {
                return DHStandardGroups.rfc7919_ffdhe6144;
            }
            case 260: {
                return DHStandardGroups.rfc7919_ffdhe8192;
            }
        }
        return null;
    }

    public static boolean isDHECipherSuite(int cipherSuite) {
        switch (TlsUtils.getKeyExchangeAlgorithm(cipherSuite)) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public static TlsDHConfig readDHConfig(InputStream input) throws IOException {
        BigInteger p = TlsDHUtils.readDHParameter(input);
        BigInteger g = TlsDHUtils.readDHParameter(input);
        return new TlsDHConfig(new DHGroup(p, null, g, 0));
    }

    public static TlsDHConfig receiveDHConfig(TlsDHConfigVerifier dhConfigVerifier, InputStream input) throws IOException {
        TlsDHConfig dhConfig = TlsDHUtils.readDHConfig(input);
        if (!dhConfigVerifier.accept(dhConfig)) {
            throw new TlsFatalAlert(71);
        }
        return dhConfig;
    }

    public static BigInteger readDHParameter(InputStream input) throws IOException {
        return new BigInteger(1, TlsUtils.readOpaque16(input));
    }

    public static void writeDHConfig(TlsDHConfig dhConfig, OutputStream output) throws IOException {
        if (dhConfig.getNamedGroup() >= 0) {
            throw new TlsFatalAlert(80);
        }
        DHGroup explicitGroup = dhConfig.getExplicitGroup();
        TlsDHUtils.writeDHParameter(explicitGroup.getP(), output);
        TlsDHUtils.writeDHParameter(explicitGroup.getG(), output);
    }

    public static void writeDHParameter(BigInteger x, OutputStream output) throws IOException {
        TlsUtils.writeOpaque16(BigIntegers.asUnsignedByteArray(x), output);
    }
}

