/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.openecard.bouncycastle.tls.Certificate;
import org.openecard.bouncycastle.tls.CertificateRequest;
import org.openecard.bouncycastle.tls.DigestInputBuffer;
import org.openecard.bouncycastle.tls.DigitallySigned;
import org.openecard.bouncycastle.tls.TlsCredentialedSigner;
import org.openecard.bouncycastle.tls.TlsCredentials;
import org.openecard.bouncycastle.tls.TlsDHConfigVerifier;
import org.openecard.bouncycastle.tls.TlsDHKeyExchange;
import org.openecard.bouncycastle.tls.TlsDHUtils;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsDHConfig;
import org.openecard.bouncycastle.tls.crypto.TlsVerifier;
import org.openecard.bouncycastle.util.io.TeeInputStream;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 3: 
            case 5: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfigVerifier dhConfigVerifier) {
        super(TlsDHEKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms, dhConfigVerifier);
    }

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfig dhConfig) {
        super(TlsDHEKeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms, dhConfig);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhConfig == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer buf = new DigestInputBuffer();
        TlsDHUtils.writeDHConfig(this.dhConfig, buf);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.generateEphemeral(buf);
        DigitallySigned signedParams = TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, buf);
        signedParams.encode(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, teeIn);
        byte[] y = TlsUtils.readOpaque16(teeIn);
        DigitallySigned signedParams = this.parseSignature(input);
        TlsUtils.verifyServerKeyExchangeSignature(this.context, this.verifier, buf, signedParams);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.processEphemeral(y);
    }

    @Override
    public void validateCertificateRequest(CertificateRequest certificateRequest) throws IOException {
        short[] types = certificateRequest.getCertificateTypes();
        block3: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case 1: 
                case 2: 
                case 64: {
                    continue block3;
                }
                default: {
                    throw new TlsFatalAlert(47);
                }
            }
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }
}

