/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import org.openecard.bouncycastle.tls.AbstractTlsClient;
import org.openecard.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import org.openecard.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import org.openecard.bouncycastle.tls.TlsAuthentication;
import org.openecard.bouncycastle.tls.TlsDHConfigVerifier;
import org.openecard.bouncycastle.tls.TlsECConfigVerifier;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsKeyExchange;
import org.openecard.bouncycastle.tls.TlsKeyExchangeFactory;
import org.openecard.bouncycastle.tls.TlsPSKIdentity;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;
import org.openecard.bouncycastle.util.Arrays;

public class PSKTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsPSKIdentity pskIdentity;
    protected int[] supportedCipherSuites;

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier(), pskIdentity);
    }

    public PSKTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsDHConfigVerifier dhConfigVerifier, TlsPSKIdentity pskIdentity) {
        super(crypto, keyExchangeFactory);
        this.dhConfigVerifier = dhConfigVerifier;
        this.pskIdentity = pskIdentity;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 14: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, this.dhConfigVerifier, null);
            }
            case 24: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, this.createECConfigVerifier());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(keyExchangeAlgorithm, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, dhConfigVerifier, ecConfigVerifier, this.clientECPointFormats, this.serverECPointFormats);
    }
}

