/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.openecard.bouncycastle.tls.DTLSHandshakeRetransmit;
import org.openecard.bouncycastle.tls.DTLSReassembler;
import org.openecard.bouncycastle.tls.DTLSRecordLayer;
import org.openecard.bouncycastle.tls.DeferredHash;
import org.openecard.bouncycastle.tls.TlsContext;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsHandshakeHash;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.util.Integers;

class DTLSReliableHandshake {
    private static final int MAX_RECEIVE_AHEAD = 16;
    private static final int MESSAGE_HEADER_LENGTH = 12;
    private DTLSRecordLayer recordLayer;
    private TlsHandshakeHash handshakeHash;
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private boolean sending = true;
    private int message_seq = 0;
    private int next_receive_seq = 0;

    DTLSReliableHandshake(TlsContext context, DTLSRecordLayer transport) {
        this.recordLayer = transport;
        this.handshakeHash = new DeferredHash(context);
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash result = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return result;
    }

    void sendMessage(short msg_type, byte[] body) throws IOException {
        TlsUtils.checkUint24(body.length);
        if (!this.sending) {
            this.checkInboundFlight();
            this.sending = true;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.message_seq++, msg_type, body);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    byte[] receiveMessageBody(short msg_type) throws IOException {
        Message message = this.receiveMessage();
        if (message.getType() != msg_type) {
            throw new TlsFatalAlert(10);
        }
        return message.getBody();
    }

    Message receiveMessage() throws IOException {
        if (this.sending) {
            this.sending = false;
            this.prepareInboundFlight(new Hashtable());
        }
        byte[] buf = null;
        int readTimeoutMillis = 1000;
        while (true) {
            try {
                while (true) {
                    int received;
                    Message pending;
                    if ((pending = this.getPendingMessage()) != null) {
                        return pending;
                    }
                    int receiveLimit = this.recordLayer.getReceiveLimit();
                    if (buf == null || buf.length < receiveLimit) {
                        buf = new byte[receiveLimit];
                    }
                    if ((received = this.recordLayer.receive(buf, 0, receiveLimit, readTimeoutMillis)) >= 0) {
                        boolean resentOutbound = this.processRecord(16, this.recordLayer.getReadEpoch(), buf, 0, received);
                        if (!resentOutbound) continue;
                        readTimeoutMillis = this.backOff(readTimeoutMillis);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.resendOutboundFlight();
            readTimeoutMillis = this.backOff(readTimeoutMillis);
        }
    }

    void finish() {
        DTLSHandshakeRetransmit retransmit = null;
        if (!this.sending) {
            this.checkInboundFlight();
        } else {
            this.prepareInboundFlight(null);
            if (this.previousInboundFlight != null) {
                retransmit = new DTLSHandshakeRetransmit(){

                    @Override
                    public void receivedHandshakeRecord(int epoch, byte[] buf, int off, int len) throws IOException {
                        DTLSReliableHandshake.this.processRecord(0, epoch, buf, off, len);
                    }
                };
            }
        }
        this.recordLayer.handshakeSuccessful(retransmit);
    }

    void resetHandshakeMessagesDigest() {
        this.handshakeHash.reset();
    }

    private int backOff(int timeoutMillis) {
        return Math.min(timeoutMillis * 2, 60000);
    }

    private void checkInboundFlight() {
        Enumeration e = this.currentInboundFlight.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            if (key < this.next_receive_seq) continue;
        }
    }

    private Message getPendingMessage() throws IOException {
        byte[] body;
        DTLSReassembler next = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(this.next_receive_seq));
        if (next != null && (body = next.getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return this.updateHandshakeMessagesDigest(new Message(this.next_receive_seq++, next.getMsgType(), body));
        }
        return null;
    }

    private void prepareInboundFlight(Hashtable nextFlight) {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = nextFlight;
    }

    private boolean processRecord(int windowSize, int epoch, byte[] buf, int off, int len) throws IOException {
        boolean result;
        int fragment_length;
        int message_length;
        boolean checkPreviousFlight = false;
        while (len >= 12 && len >= (message_length = (fragment_length = TlsUtils.readUint24(buf, off + 9)) + 12)) {
            int expectedEpoch;
            int length = TlsUtils.readUint24(buf, off + 1);
            int fragment_offset = TlsUtils.readUint24(buf, off + 6);
            if (fragment_offset + fragment_length > length) break;
            short msg_type = TlsUtils.readUint8(buf, off + 0);
            int n = expectedEpoch = msg_type == 20 ? 1 : 0;
            if (epoch != expectedEpoch) break;
            int message_seq = TlsUtils.readUint16(buf, off + 4);
            if (message_seq < this.next_receive_seq + windowSize) {
                DTLSReassembler reassembler;
                if (message_seq >= this.next_receive_seq) {
                    reassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf(message_seq));
                    if (reassembler == null) {
                        reassembler = new DTLSReassembler(msg_type, length);
                        this.currentInboundFlight.put(Integers.valueOf(message_seq), reassembler);
                    }
                    reassembler.contributeFragment(msg_type, length, buf, off + 12, fragment_offset, fragment_length);
                } else if (this.previousInboundFlight != null && (reassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf(message_seq))) != null) {
                    reassembler.contributeFragment(msg_type, length, buf, off + 12, fragment_offset, fragment_length);
                    checkPreviousFlight = true;
                }
            }
            off += message_length;
            len -= message_length;
        }
        boolean bl = result = checkPreviousFlight && DTLSReliableHandshake.checkAll(this.previousInboundFlight);
        if (result) {
            this.resendOutboundFlight();
            DTLSReliableHandshake.resetAll(this.previousInboundFlight);
        }
        return result;
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i = 0; i < this.outboundFlight.size(); ++i) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i));
        }
    }

    private Message updateHandshakeMessagesDigest(Message message) throws IOException {
        if (message.getType() != 0) {
            byte[] body = message.getBody();
            byte[] buf = new byte[12];
            TlsUtils.writeUint8(message.getType(), buf, 0);
            TlsUtils.writeUint24(body.length, buf, 1);
            TlsUtils.writeUint16(message.getSeq(), buf, 4);
            TlsUtils.writeUint24(0, buf, 6);
            TlsUtils.writeUint24(body.length, buf, 9);
            this.handshakeHash.update(buf, 0, buf.length);
            this.handshakeHash.update(body, 0, body.length);
        }
        return message;
    }

    private void writeMessage(Message message) throws IOException {
        int fragment_length;
        int sendLimit = this.recordLayer.getSendLimit();
        int fragmentLimit = sendLimit - 12;
        if (fragmentLimit < 1) {
            throw new TlsFatalAlert(80);
        }
        int length = message.getBody().length;
        int fragment_offset = 0;
        do {
            fragment_length = Math.min(length - fragment_offset, fragmentLimit);
            this.writeHandshakeFragment(message, fragment_offset, fragment_length);
        } while ((fragment_offset += fragment_length) < length);
    }

    private void writeHandshakeFragment(Message message, int fragment_offset, int fragment_length) throws IOException {
        RecordLayerBuffer fragment = new RecordLayerBuffer(12 + fragment_length);
        TlsUtils.writeUint8(message.getType(), (OutputStream)fragment);
        TlsUtils.writeUint24(message.getBody().length, fragment);
        TlsUtils.writeUint16(message.getSeq(), fragment);
        TlsUtils.writeUint24(fragment_offset, fragment);
        TlsUtils.writeUint24(fragment_length, fragment);
        fragment.write(message.getBody(), fragment_offset, fragment_length);
        fragment.sendToRecordLayer(this.recordLayer);
    }

    private static boolean checkAll(Hashtable inboundFlight) {
        Enumeration e = inboundFlight.elements();
        while (e.hasMoreElements()) {
            if (((DTLSReassembler)e.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable inboundFlight) {
        Enumeration e = inboundFlight.elements();
        while (e.hasMoreElements()) {
            ((DTLSReassembler)e.nextElement()).reset();
        }
    }

    static class RecordLayerBuffer
    extends ByteArrayOutputStream {
        RecordLayerBuffer(int size) {
            super(size);
        }

        void sendToRecordLayer(DTLSRecordLayer recordLayer) throws IOException {
            recordLayer.send(this.buf, 0, this.count);
            this.buf = null;
        }
    }

    static class Message {
        private final int message_seq;
        private final short msg_type;
        private final byte[] body;

        private Message(int message_seq, short msg_type, byte[] body) {
            this.message_seq = message_seq;
            this.msg_type = msg_type;
            this.body = body;
        }

        public int getSeq() {
            return this.message_seq;
        }

        public short getType() {
            return this.msg_type;
        }

        public byte[] getBody() {
            return this.body;
        }
    }
}

