/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.openecard.bouncycastle.tls.TlsContext;
import org.openecard.bouncycastle.tls.TlsUtils;
import org.openecard.bouncycastle.tls.crypto.TlsCertificate;

public class Certificate {
    public static final Certificate EMPTY_CHAIN = new Certificate(new TlsCertificate[0]);
    protected TlsCertificate[] certificateList;

    public Certificate(TlsCertificate[] certificateList) {
        if (certificateList == null) {
            throw new IllegalArgumentException("'certificateList' cannot be null");
        }
        this.certificateList = certificateList;
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int index) {
        return this.certificateList[index];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream output) throws IOException {
        byte[] derEncoding;
        int i;
        Vector<byte[]> derEncodings = new Vector<byte[]>(this.certificateList.length);
        int totalLength = 0;
        for (i = 0; i < this.certificateList.length; ++i) {
            derEncoding = this.certificateList[i].getEncoded();
            derEncodings.addElement(derEncoding);
            totalLength += derEncoding.length + 3;
        }
        TlsUtils.checkUint24(totalLength);
        TlsUtils.writeUint24(totalLength, output);
        for (i = 0; i < derEncodings.size(); ++i) {
            derEncoding = (byte[])derEncodings.elementAt(i);
            TlsUtils.writeOpaque24(derEncoding, output);
        }
    }

    public static Certificate parse(TlsContext context, InputStream input) throws IOException {
        int totalLength = TlsUtils.readUint24(input);
        if (totalLength == 0) {
            return EMPTY_CHAIN;
        }
        byte[] certListData = TlsUtils.readFully(totalLength, input);
        ByteArrayInputStream buf = new ByteArrayInputStream(certListData);
        Vector<TlsCertificate> certificate_list = new Vector<TlsCertificate>();
        while (buf.available() > 0) {
            byte[] derEncoding = TlsUtils.readOpaque24(buf);
            certificate_list.addElement(context.getCrypto().createCertificate(derEncoding));
        }
        TlsCertificate[] certificateList = new TlsCertificate[certificate_list.size()];
        for (int i = 0; i < certificate_list.size(); ++i) {
            certificateList[i] = (TlsCertificate)certificate_list.elementAt(i);
        }
        return new Certificate(certificateList);
    }

    protected TlsCertificate[] cloneCertificateList() {
        TlsCertificate[] result = new TlsCertificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, result, 0, result.length);
        return result;
    }
}

