/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.tls;

import java.io.IOException;
import org.openecard.bouncycastle.tls.TlsFatalAlert;
import org.openecard.bouncycastle.tls.TlsPeer;
import org.openecard.bouncycastle.tls.crypto.TlsCrypto;

public abstract class AbstractTlsPeer
implements TlsPeer {
    private final TlsCrypto crypto;

    protected AbstractTlsPeer(TlsCrypto crypto) {
        this.crypto = crypto;
    }

    @Override
    public TlsCrypto getCrypto() {
        return this.crypto;
    }

    @Override
    public boolean shouldUseGMTUnixTime() {
        return false;
    }

    @Override
    public void notifySecureRenegotiation(boolean secureRenegotiation) throws IOException {
        if (!secureRenegotiation) {
            throw new TlsFatalAlert(40);
        }
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
    }
}

