/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.pkcs.jcajce;

import java.io.OutputStream;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.openecard.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.openecard.bouncycastle.asn1.ASN1Primitive;
import org.openecard.bouncycastle.asn1.DERNull;
import org.openecard.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.openecard.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.openecard.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.openecard.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.openecard.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.openecard.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.openecard.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.jcajce.PKCS12KeyWithParameters;
import org.openecard.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.openecard.bouncycastle.jcajce.util.JcaJceHelper;
import org.openecard.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.openecard.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.openecard.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.openecard.bouncycastle.operator.GenericKey;
import org.openecard.bouncycastle.operator.OperatorCreationException;
import org.openecard.bouncycastle.operator.OutputEncryptor;
import org.openecard.bouncycastle.operator.SecretKeySizeProvider;
import org.openecard.bouncycastle.pkcs.jcajce.JceUtils;

public class JcePKCSPBEOutputEncryptorBuilder {
    private JcaJceHelper helper = new DefaultJcaJceHelper();
    private ASN1ObjectIdentifier algorithm;
    private ASN1ObjectIdentifier keyEncAlgorithm;
    private SecureRandom random;
    private SecretKeySizeProvider keySizeProvider = DefaultSecretKeySizeProvider.INSTANCE;
    private int iterationCount = 1024;
    private AlgorithmIdentifier prf = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA1, DERNull.INSTANCE);

    public JcePKCSPBEOutputEncryptorBuilder(ASN1ObjectIdentifier algorithm) {
        if (this.isPKCS12(algorithm)) {
            this.algorithm = algorithm;
            this.keyEncAlgorithm = algorithm;
        } else {
            this.algorithm = PKCSObjectIdentifiers.id_PBES2;
            this.keyEncAlgorithm = algorithm;
        }
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(Provider provider) {
        this.helper = new ProviderJcaJceHelper(provider);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setProvider(String providerName) {
        this.helper = new NamedJcaJceHelper(providerName);
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setPRF(AlgorithmIdentifier prf) {
        this.prf = prf;
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setKeySizeProvider(SecretKeySizeProvider keySizeProvider) {
        this.keySizeProvider = keySizeProvider;
        return this;
    }

    public JcePKCSPBEOutputEncryptorBuilder setIterationCount(int iterationCount) {
        this.iterationCount = iterationCount;
        return this;
    }

    public OutputEncryptor build(final char[] password) throws OperatorCreationException {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            AlgorithmIdentifier encryptionAlg;
            Cipher cipher;
            if (this.isPKCS12(this.algorithm)) {
                byte[] salt = new byte[20];
                this.random.nextBytes(salt);
                cipher = this.helper.createCipher(this.algorithm.getId());
                cipher.init(1, new PKCS12KeyWithParameters(password, salt, this.iterationCount));
                encryptionAlg = new AlgorithmIdentifier(this.algorithm, new PKCS12PBEParams(salt, this.iterationCount));
            } else if (this.algorithm.equals(PKCSObjectIdentifiers.id_PBES2)) {
                byte[] salt = new byte[JceUtils.getSaltSize(this.prf.getAlgorithm())];
                this.random.nextBytes(salt);
                SecretKeyFactory keyFact = this.helper.createSecretKeyFactory(JceUtils.getAlgorithm(this.prf.getAlgorithm()));
                SecretKey key = keyFact.generateSecret(new PBEKeySpec(password, salt, this.iterationCount, this.keySizeProvider.getKeySize(new AlgorithmIdentifier(this.keyEncAlgorithm))));
                cipher = this.helper.createCipher(this.keyEncAlgorithm.getId());
                cipher.init(1, (Key)key, this.random);
                PBES2Parameters algParams = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(salt, this.iterationCount, this.prf)), new EncryptionScheme(this.keyEncAlgorithm, ASN1Primitive.fromByteArray(cipher.getParameters().getEncoded())));
                encryptionAlg = new AlgorithmIdentifier(this.algorithm, algParams);
            } else {
                throw new OperatorCreationException("unrecognised algorithm");
            }
            return new OutputEncryptor(){

                @Override
                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return encryptionAlg;
                }

                @Override
                public OutputStream getOutputStream(OutputStream out) {
                    return new CipherOutputStream(out, cipher);
                }

                @Override
                public GenericKey getKey() {
                    if (JcePKCSPBEOutputEncryptorBuilder.this.isPKCS12(encryptionAlg.getAlgorithm())) {
                        return new GenericKey(encryptionAlg, JcePKCSPBEOutputEncryptorBuilder.PKCS12PasswordToBytes(password));
                    }
                    return new GenericKey(encryptionAlg, JcePKCSPBEOutputEncryptorBuilder.PKCS5PasswordToBytes(password));
                }
            };
        }
        catch (Exception e) {
            throw new OperatorCreationException("unable to create OutputEncryptor: " + e.getMessage(), e);
        }
    }

    private boolean isPKCS12(ASN1ObjectIdentifier algorithm) {
        return algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds) || algorithm.on(BCObjectIdentifiers.bc_pbe_sha1_pkcs12) || algorithm.on(BCObjectIdentifiers.bc_pbe_sha256_pkcs12);
    }

    private static byte[] PKCS5PasswordToBytes(char[] password) {
        if (password != null) {
            byte[] bytes = new byte[password.length];
            for (int i = 0; i != bytes.length; ++i) {
                bytes[i] = (byte)password[i];
            }
            return bytes;
        }
        return new byte[0];
    }

    private static byte[] PKCS12PasswordToBytes(char[] password) {
        if (password != null && password.length > 0) {
            byte[] bytes = new byte[(password.length + 1) * 2];
            for (int i = 0; i != password.length; ++i) {
                bytes[i * 2] = (byte)(password[i] >>> 8);
                bytes[i * 2 + 1] = (byte)password[i];
            }
            return bytes;
        }
        return new byte[0];
    }
}

