/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jsse.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.openecard.bouncycastle.jsse.BCSSLConnection;
import org.openecard.bouncycastle.jsse.provider.ContextData;
import org.openecard.bouncycastle.jsse.provider.ProvSSLConnection;
import org.openecard.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.openecard.bouncycastle.jsse.provider.ProvSSLParameters;
import org.openecard.bouncycastle.jsse.provider.ProvSSLSession;
import org.openecard.bouncycastle.jsse.provider.ProvSSLSocketBase;
import org.openecard.bouncycastle.jsse.provider.ProvTlsClient;
import org.openecard.bouncycastle.jsse.provider.ProvTlsManager;
import org.openecard.bouncycastle.jsse.provider.ProvTlsPeer;
import org.openecard.bouncycastle.jsse.provider.ProvTlsServer;
import org.openecard.bouncycastle.jsse.provider.SSLParametersUtil;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.bouncycastle.tls.TlsProtocol;
import org.openecard.bouncycastle.tls.TlsServerProtocol;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port) throws IOException {
        super(address, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port) throws IOException, UnknownHostException {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol != null) {
            this.protocol.close();
        }
        super.close();
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public synchronized SSLSession getSession() {
        BCSSLConnection connection = this.getConnection();
        return connection == null ? ProvSSLSession.NULL_SESSION : connection.getSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        if (!this.context.isSupportedCipherSuites(suites)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        if (this.initialHandshakeBegun && mode != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol(super.getInputStream(), super.getOutputStream());
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this);
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol(super.getInputStream(), super.getOutputStream());
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this);
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        }
        finally {
            this.handshakeSession = null;
        }
    }

    @Override
    public String getPeerHost() {
        String peerHost;
        int pos;
        InetAddress peerAddress = this.getInetAddress();
        if (peerAddress != null && (pos = (peerHost = peerAddress.toString()).lastIndexOf(47)) > 0) {
            return peerHost.substring(0, pos);
        }
        return null;
    }

    @Override
    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    synchronized void handshakeIfNecessary() throws IOException {
        if (!this.initialHandshakeBegun) {
            this.startHandshake();
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                if (ProvSSLSocketDirect.this.protocol != null) {
                    ProvSSLSocketDirect.this.protocol.flush();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary();
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketDirect.this.protocol.writeApplicationData(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary();
                ProvSSLSocketDirect.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        @Override
        public int read() throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary();
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketDirect.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary();
            return ProvSSLSocketDirect.this.protocol.readApplicationData(b, off, len);
        }
    }
}

