/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jsse.provider;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;
import org.openecard.bouncycastle.jsse.BCSSLConnection;
import org.openecard.bouncycastle.jsse.BCSSLEngine;
import org.openecard.bouncycastle.jsse.provider.ContextData;
import org.openecard.bouncycastle.jsse.provider.ProvSSLConnection;
import org.openecard.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.openecard.bouncycastle.jsse.provider.ProvSSLParameters;
import org.openecard.bouncycastle.jsse.provider.ProvSSLSession;
import org.openecard.bouncycastle.jsse.provider.ProvTlsClient;
import org.openecard.bouncycastle.jsse.provider.ProvTlsManager;
import org.openecard.bouncycastle.jsse.provider.ProvTlsPeer;
import org.openecard.bouncycastle.jsse.provider.ProvTlsServer;
import org.openecard.bouncycastle.jsse.provider.SSLParametersUtil;
import org.openecard.bouncycastle.tls.TlsClientProtocol;
import org.openecard.bouncycastle.tls.TlsProtocol;
import org.openecard.bouncycastle.tls.TlsServerProtocol;

class ProvSSLEngine
extends SSLEngine
implements BCSSLEngine,
ProvTlsManager {
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = false;
    protected boolean useClientMode = true;
    protected boolean initialHandshakeBegun = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;
    protected SSLException deferredException = null;

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    protected ProvSSLEngine(ProvSSLContextSpi context, ContextData contextData, String host, int port) {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = ProvSSLParameters.extractDefaultParameters(context);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void beginHandshake() throws SSLException {
        if (this.initialHandshakeBegun) {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
        this.initialHandshakeBegun = true;
        try {
            if (this.useClientMode) {
                TlsClientProtocol clientProtocol = new TlsClientProtocol();
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this);
                this.protocolPeer = client;
                clientProtocol.connect(client);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else {
                TlsServerProtocol serverProtocol = new TlsServerProtocol();
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this);
                this.protocolPeer = server;
                serverProtocol.accept(server);
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    @Override
    public synchronized void closeInbound() throws SSLException {
        try {
            this.protocol.closeInput();
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    @Override
    public synchronized void closeOutbound() {
        try {
            this.protocol.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public synchronized SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        return this.handshakeStatus;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public synchronized SSLSession getSession() {
        return this.connection == null ? ProvSSLSession.NULL_SESSION : this.connection.getSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.toSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized ProvSSLParameters getProvSSLParameters() {
        return this.sslParameters;
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized boolean isInboundDone() {
        return this.protocol != null && this.protocol.isClosed();
    }

    @Override
    public synchronized boolean isOutboundDone() {
        return this.protocol != null && this.protocol.isClosed() && this.protocol.getAvailableOutputBytes() < 1;
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        if (!this.context.isSupportedCipherSuites(suites)) {
            throw new IllegalArgumentException("'suites' cannot be null, or contain unsupported cipher suites");
        }
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        if (!this.context.isSupportedProtocols(protocols)) {
            throw new IllegalArgumentException("'protocols' cannot be null, or contain unsupported protocols");
        }
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        this.sslParameters = SSLParametersUtil.toProvSSLParameters(sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        if (this.initialHandshakeBegun && mode != this.useClientMode) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        int count;
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (!this.protocol.isClosed()) {
            int srcLimit = ProvSSLSession.NULL_SESSION.getApplicationBufferSize() + 5;
            int count2 = Math.min(src.remaining(), srcLimit);
            if (count2 > 0) {
                byte[] buf = new byte[count2];
                src.get(buf);
                try {
                    this.protocol.offerInput(buf);
                }
                catch (IOException e) {
                    if (this.deferredException == null) {
                        this.deferredException = new SSLException(e);
                    }
                    this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                    return new SSLEngineResult(SSLEngineResult.Status.OK, SSLEngineResult.HandshakeStatus.NEED_WRAP, bytesConsumed, bytesProduced);
                }
                bytesConsumed += count2;
                srcLimit -= count2;
            }
        }
        int inputAvailable = this.protocol.getAvailableInputBytes();
        for (int dstIndex = 0; dstIndex < length && inputAvailable > 0; inputAvailable -= count, ++dstIndex) {
            ByteBuffer dst = dsts[dstIndex];
            count = Math.min(dst.remaining(), inputAvailable);
            byte[] input = new byte[count];
            int numRead = this.protocol.readInput(input, 0, count);
            assert (numRead == count);
            dst.put(input);
            bytesProduced += count;
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        if (inputAvailable > 0) {
            resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
        } else if (this.protocol.isClosed()) {
            resultStatus = SSLEngineResult.Status.CLOSED;
        } else if (bytesConsumed == 0) {
            resultStatus = SSLEngineResult.Status.BUFFER_UNDERFLOW;
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            if (this.protocol.getAvailableOutputBytes() > 0) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_WRAP;
            } else if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public synchronized SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        int outputAvailable;
        if (this.deferredException != null) {
            SSLException e = this.deferredException;
            this.deferredException = null;
            throw e;
        }
        if (!this.initialHandshakeBegun) {
            this.beginHandshake();
        }
        SSLEngineResult.Status resultStatus = SSLEngineResult.Status.OK;
        int bytesConsumed = 0;
        int bytesProduced = 0;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (this.protocol.isClosed()) {
                resultStatus = SSLEngineResult.Status.CLOSED;
            } else {
                int srcLimit = ProvSSLSession.NULL_SESSION.getApplicationBufferSize();
                for (int srcIndex = 0; srcIndex < length && srcLimit > 0; ++srcIndex) {
                    ByteBuffer src = srcs[srcIndex];
                    int count = Math.min(src.remaining(), srcLimit);
                    if (count <= 0) continue;
                    byte[] input = new byte[count];
                    src.get(input);
                    try {
                        this.protocol.writeApplicationData(input, 0, count);
                    }
                    catch (IOException e) {
                        throw new SSLException(e);
                    }
                    bytesConsumed += count;
                    srcLimit -= count;
                }
            }
        }
        if ((outputAvailable = this.protocol.getAvailableOutputBytes()) > 0) {
            int count = Math.min(dst.remaining(), outputAvailable);
            if (count > 0) {
                byte[] output = new byte[count];
                int numRead = this.protocol.readOutput(output, 0, count);
                assert (numRead == count);
                dst.put(output);
                bytesProduced += count;
                outputAvailable -= count;
            }
            if (outputAvailable > 0) {
                resultStatus = SSLEngineResult.Status.BUFFER_OVERFLOW;
            }
        }
        SSLEngineResult.HandshakeStatus resultHandshakeStatus = this.handshakeStatus;
        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP && outputAvailable <= 0) {
            if (this.protocolPeer.isHandshakeComplete()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.FINISHED;
            } else if (this.protocol.isClosed()) {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
            } else {
                this.handshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                resultHandshakeStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
            }
        }
        return new SSLEngineResult(resultStatus, resultHandshakeStatus, bytesConsumed, bytesProduced);
    }

    @Override
    public String getPeerHost() {
        return super.getPeerHost();
    }

    @Override
    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }
}

