/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.jcajce;

import org.openecard.bouncycastle.crypto.CharToByteConverter;
import org.openecard.bouncycastle.jcajce.PBKDFKey;
import org.openecard.bouncycastle.util.Arrays;

public class PBKDF2Key
implements PBKDFKey {
    private final char[] password;
    private final CharToByteConverter converter;

    public PBKDF2Key(char[] password, CharToByteConverter converter) {
        this.password = Arrays.clone(password);
        this.converter = converter;
    }

    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getAlgorithm() {
        return "PBKDF2";
    }

    @Override
    public String getFormat() {
        return this.converter.getType();
    }

    @Override
    public byte[] getEncoded() {
        return this.converter.convert(this.password);
    }
}

