/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms.bc;

import java.io.InputStream;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.cms.RecipientOperator;
import org.openecard.bouncycastle.cms.bc.BcKEKRecipient;
import org.openecard.bouncycastle.cms.bc.EnvelopedDataHelper;
import org.openecard.bouncycastle.crypto.BufferedBlockCipher;
import org.openecard.bouncycastle.crypto.StreamCipher;
import org.openecard.bouncycastle.crypto.io.CipherInputStream;
import org.openecard.bouncycastle.crypto.params.KeyParameter;
import org.openecard.bouncycastle.operator.InputDecryptor;
import org.openecard.bouncycastle.operator.bc.BcSymmetricKeyUnwrapper;

public class BcKEKEnvelopedRecipient
extends BcKEKRecipient {
    public BcKEKEnvelopedRecipient(BcSymmetricKeyUnwrapper unwrapper) {
        super(unwrapper);
    }

    @Override
    public RecipientOperator getRecipientOperator(AlgorithmIdentifier keyEncryptionAlgorithm, final AlgorithmIdentifier contentEncryptionAlgorithm, byte[] encryptedContentEncryptionKey) throws CMSException {
        KeyParameter secretKey = (KeyParameter)this.extractSecretKey(keyEncryptionAlgorithm, contentEncryptionAlgorithm, encryptedContentEncryptionKey);
        final Object dataCipher = EnvelopedDataHelper.createContentCipher(false, secretKey, contentEncryptionAlgorithm);
        return new RecipientOperator(new InputDecryptor(){

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return contentEncryptionAlgorithm;
            }

            @Override
            public InputStream getInputStream(InputStream dataOut) {
                if (dataCipher instanceof BufferedBlockCipher) {
                    return new CipherInputStream(dataOut, (BufferedBlockCipher)dataCipher);
                }
                return new CipherInputStream(dataOut, (StreamCipher)dataCipher);
            }
        });
    }
}

