/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.bouncycastle.cms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.openecard.bouncycastle.asn1.ASN1Encodable;
import org.openecard.bouncycastle.asn1.ASN1Set;
import org.openecard.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.openecard.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.openecard.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.openecard.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.openecard.bouncycastle.asn1.cms.RecipientInfo;
import org.openecard.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.openecard.bouncycastle.cms.AuthAttributesProvider;
import org.openecard.bouncycastle.cms.CMSException;
import org.openecard.bouncycastle.cms.CMSReadable;
import org.openecard.bouncycastle.cms.CMSSecureReadable;
import org.openecard.bouncycastle.cms.KEKRecipientInformation;
import org.openecard.bouncycastle.cms.KeyAgreeRecipientInformation;
import org.openecard.bouncycastle.cms.KeyTransRecipientInformation;
import org.openecard.bouncycastle.cms.PasswordRecipientInformation;
import org.openecard.bouncycastle.cms.RecipientInformation;
import org.openecard.bouncycastle.cms.RecipientInformationStore;
import org.openecard.bouncycastle.operator.DigestCalculator;

class CMSEnvelopedHelper {
    CMSEnvelopedHelper() {
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable) {
        return CMSEnvelopedHelper.buildRecipientInformationStore(recipientInfos, messageAlgorithm, secureReadable, null);
    }

    static RecipientInformationStore buildRecipientInformationStore(ASN1Set recipientInfos, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ArrayList<RecipientInformation> infos = new ArrayList<RecipientInformation>();
        for (int i = 0; i != recipientInfos.size(); ++i) {
            RecipientInfo info = RecipientInfo.getInstance(recipientInfos.getObjectAt(i));
            CMSEnvelopedHelper.readRecipientInfo(infos, info, messageAlgorithm, secureReadable, additionalData);
        }
        return new RecipientInformationStore(infos);
    }

    private static void readRecipientInfo(List infos, RecipientInfo info, AlgorithmIdentifier messageAlgorithm, CMSSecureReadable secureReadable, AuthAttributesProvider additionalData) {
        ASN1Encodable recipInfo = info.getInfo();
        if (recipInfo instanceof KeyTransRecipientInfo) {
            infos.add(new KeyTransRecipientInformation((KeyTransRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        } else if (recipInfo instanceof KEKRecipientInfo) {
            infos.add(new KEKRecipientInformation((KEKRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        } else if (recipInfo instanceof KeyAgreeRecipientInfo) {
            KeyAgreeRecipientInformation.readRecipientInfo(infos, (KeyAgreeRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData);
        } else if (recipInfo instanceof PasswordRecipientInfo) {
            infos.add(new PasswordRecipientInformation((PasswordRecipientInfo)recipInfo, messageAlgorithm, secureReadable, additionalData));
        }
    }

    static class CMSEnvelopedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private CMSReadable readable;

        CMSEnvelopedSecureReadable(AlgorithmIdentifier algorithm, CMSReadable readable) {
            this.algorithm = algorithm;
            this.readable = readable;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }

    static class CMSAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private AlgorithmIdentifier algorithm;
        private CMSReadable readable;

        CMSAuthenticatedSecureReadable(AlgorithmIdentifier algorithm, CMSReadable readable) {
            this.algorithm = algorithm;
            this.readable = readable;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return this.readable.getInputStream();
        }
    }

    static class CMSDigestAuthenticatedSecureReadable
    implements CMSSecureReadable {
        private DigestCalculator digestCalculator;
        private CMSReadable readable;

        public CMSDigestAuthenticatedSecureReadable(DigestCalculator digestCalculator, CMSReadable readable) {
            this.digestCalculator = digestCalculator;
            this.readable = readable;
        }

        @Override
        public InputStream getInputStream() throws IOException, CMSException {
            return new FilterInputStream(this.readable.getInputStream()){

                @Override
                public int read() throws IOException {
                    int b = this.in.read();
                    if (b >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(b);
                    }
                    return b;
                }

                @Override
                public int read(byte[] inBuf, int inOff, int inLen) throws IOException {
                    int n = this.in.read(inBuf, inOff, inLen);
                    if (n >= 0) {
                        CMSDigestAuthenticatedSecureReadable.this.digestCalculator.getOutputStream().write(inBuf, inOff, n);
                    }
                    return n;
                }
            };
        }

        public byte[] getDigest() {
            return this.digestCalculator.getDigest();
        }
    }
}

