/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import generated.TCTokenType;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import javax.annotation.Nonnull;
import org.openecard.binding.tctoken.RedirectCertificateValidator;
import org.openecard.binding.tctoken.ResourceContext;
import org.openecard.binding.tctoken.ResourceException;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenHacks;
import org.openecard.binding.tctoken.ValidationError;
import org.openecard.binding.tctoken.ex.ActivationError;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidAddressException;
import org.openecard.binding.tctoken.ex.InvalidRedirectUrlException;
import org.openecard.binding.tctoken.ex.InvalidTCTokenElement;
import org.openecard.binding.tctoken.ex.InvalidTCTokenUrlException;
import org.openecard.binding.tctoken.ex.SecurityViolationException;
import org.openecard.binding.tctoken.ex.UserCancellationException;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18nKey;
import org.openecard.common.util.Pair;
import org.openecard.common.util.TR03112Utils;
import org.openecard.common.util.UrlBuilder;

public class TCTokenVerifier {
    private final TCToken token;
    private final ResourceContext ctx;

    public TCTokenVerifier(@Nonnull TCToken token, ResourceContext ctx) {
        this.token = token;
        this.ctx = ctx;
    }

    public boolean isErrorToken() {
        if (this.token.getCommunicationErrorAddress() != null) {
            return this.token.getRefreshAddress() == null;
        }
        return false;
    }

    public void verifyUrlToken() throws InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, UserCancellationException {
        this.initialUrlTokenCheck();
        this.verifyRefreshAddress();
        this.verifyCommunicationErrorAddress();
        this.checkUserCancellation();
        this.verifyServerAddress();
        this.verifySessionIdentifier();
        this.verifyBinding();
        this.verifyPathSecurity();
    }

    public void verifyServerAddress() throws InvalidRedirectUrlException, InvalidTCTokenElement, UserCancellationException {
        String value = this.token.getServerAddress();
        try {
            this.assertRequired("ServerAddress", value);
        }
        catch (InvalidTCTokenElement ex) {
            this.determineRefreshAddress(ex);
        }
        try {
            this.assertHttpsURL("ServerAddress", value);
        }
        catch (InvalidTCTokenUrlException ex) {
            this.determineRefreshAddress(ex);
        }
    }

    public void verifySessionIdentifier() throws InvalidRedirectUrlException, InvalidTCTokenElement {
        String value = this.token.getSessionIdentifier();
        this.assertRequired("SessionIdentifier", value);
    }

    public void verifyRefreshAddress() throws InvalidRedirectUrlException, InvalidTCTokenElement, UserCancellationException {
        String value = this.token.getRefreshAddress();
        this.assertRequired("RefreshAddress", value);
        try {
            this.assertHttpsURL("RefreshAddress", value);
        }
        catch (InvalidTCTokenUrlException ex) {
            this.determineRefreshAddress(ex);
        }
    }

    public void verifyCommunicationErrorAddress() throws InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException {
        String value = this.token.getCommunicationErrorAddress();
        if (!this.checkEmpty(value)) {
            this.assertRequired("CommunicationErrorAddress", value);
            this.assertHttpsURL("CommunicationErrorAddress", value);
        }
    }

    public void verifyBinding() throws InvalidRedirectUrlException, InvalidTCTokenElement {
        String value = this.token.getBinding();
        this.assertRequired("Binding", value);
        this.checkEqualOR("Binding", value, "urn:liberty:paos:2006-08", "urn:ietf:rfc:2616");
    }

    public void verifyPathSecurity() throws InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, UserCancellationException {
        String proto = this.token.getPathSecurityProtocol();
        TCTokenType.PathSecurityParameters psp = this.token.getPathSecurityParameters();
        if (this.checkEmpty(proto) && this.checkEmpty(psp)) {
            this.assertSameChannel("ServerAddress", this.token.getServerAddress());
            return;
        }
        if (!this.checkEmpty(proto) && !this.checkEmpty(psp) && this.checkEmpty(psp.getPSK()) && !this.token.isInvalidPSK()) {
            this.assertSameChannel("ServerAddress", this.token.getServerAddress());
            return;
        }
        this.assertRequired("PathSecurityProtocol", proto);
        String[] protos = new String[]{"urn:ietf:rfc:5246", "urn:ietf:rfc:4279"};
        this.checkEqualOR("PathSecurityProtocol", proto, protos);
        if ("urn:ietf:rfc:4279".equals(proto)) {
            try {
                this.assertRequired("PathSecurityParameters", psp);
            }
            catch (InvalidTCTokenElement ex) {
                this.determineRefreshAddress(ex);
            }
            try {
                this.assertRequired("PSK", psp.getPSK());
            }
            catch (InvalidTCTokenElement ex) {
                this.determineRefreshAddress(ex);
            }
        }
    }

    private boolean checkEmpty(Object value) {
        if (value != null) {
            return value instanceof String ? ((String)value).isEmpty() : (value instanceof URL ? ((URL)value).toString().isEmpty() : value instanceof byte[] && ((byte[])value).length == 0);
        }
        return true;
    }

    private void checkEqualOR(String name, String value, String ... reference) throws InvalidRedirectUrlException, InvalidTCTokenElement {
        for (String string : reference) {
            if (!value.equals(string)) continue;
            return;
        }
        String minor = "communicationError";
        String errorUrl = this.token.getComErrorAddressWithParams(minor);
        throw new InvalidTCTokenElement(errorUrl, (I18nKey)ErrorTranslations.INVALID_ELEMENT, name);
    }

    private void assertRequired(String name, Object value) throws InvalidRedirectUrlException, InvalidTCTokenElement {
        if (this.checkEmpty(value)) {
            String minor = "communicationError";
            String errorUrl = this.token.getComErrorAddressWithParams(minor);
            throw new InvalidTCTokenElement(errorUrl, (I18nKey)ErrorTranslations.MISSING_ELEMENT, name);
        }
    }

    private URL assertURL(String name, String value) throws InvalidTCTokenUrlException {
        try {
            return new URL(value);
        }
        catch (MalformedURLException e) {
            throw new InvalidTCTokenUrlException((I18nKey)ErrorTranslations.MALFORMED_URL, name);
        }
    }

    private URL assertHttpsURL(String name, String value) throws InvalidTCTokenUrlException {
        URL url = this.assertURL(name, value);
        if (!"https".equals(url.getProtocol())) {
            throw new InvalidTCTokenUrlException((I18nKey)ErrorTranslations.NO_HTTPS_URL, name);
        }
        return url;
    }

    private void assertSameChannel(String name, String address) throws InvalidRedirectUrlException, InvalidTCTokenUrlException, SecurityViolationException {
        URL paosUrl = this.assertURL(name, address);
        List<Pair<URL, TlsServerCertificate>> urls = this.ctx.getCerts();
        for (Pair<URL, TlsServerCertificate> next : urls) {
            if (TR03112Utils.checkSameOriginPolicy(paosUrl, (URL)next.p1)) continue;
            String minor = "communicationError";
            String errorUrl = this.token.getComErrorAddressWithParams(minor);
            throw new SecurityViolationException(errorUrl, (I18nKey)ErrorTranslations.FAILED_SOP, new Object[0]);
        }
    }

    private URI createUrlWithErrorParams(String refreshAddress, String minor, String minorMessage) throws URISyntaxException {
        return UrlBuilder.fromUrl(refreshAddress).queryParam("ResultMajor", "error").queryParamUrl("ResultMinor", TCTokenHacks.fixResultMinor(minor)).queryParam("ResultMessage", minorMessage).build();
    }

    private void initialUrlTokenCheck() throws InvalidRedirectUrlException, InvalidTCTokenElement {
        if (this.token.getCommunicationErrorAddress() != null && !this.token.getCommunicationErrorAddress().isEmpty() && this.token.getRefreshAddress().isEmpty() && this.token.getServerAddress().isEmpty() && this.token.getSessionIdentifier().isEmpty() && this.token.getBinding().isEmpty() && this.token.getPathSecurityProtocol().isEmpty()) {
            String errorUrl = this.token.getComErrorAddressWithParams("communicationError");
            throw new InvalidTCTokenElement(errorUrl, (I18nKey)ErrorTranslations.ESERVICE_FAIL, new Object[0]);
        }
    }

    private void determineRefreshAddress(ActivationError ex) throws InvalidRedirectUrlException, InvalidTCTokenElement, UserCancellationException {
        if (this.token.getRefreshAddress() != null) {
            try {
                RedirectCertificateValidator validator = new RedirectCertificateValidator(true);
                ResourceContext newResCtx = ResourceContext.getStream(new URL(this.token.getRefreshAddress()), validator);
                newResCtx.closeStream();
                List<Pair<URL, TlsServerCertificate>> resultPoints = newResCtx.getCerts();
                Pair<URL, TlsServerCertificate> last = resultPoints.get(resultPoints.size() - 1);
                URL resAddr = (URL)last.p1;
                String refreshUrl = resAddr.toString();
                if (ex instanceof UserCancellationException) {
                    UserCancellationException uex = (UserCancellationException)ex;
                    URI refreshUrlAsUrl = this.createUrlWithErrorParams(refreshUrl, "cancellationByUser", ex.getMessage());
                    throw new UserCancellationException(refreshUrlAsUrl.toString(), (Throwable)ex);
                }
                URI refreshUrlAsUrl = this.createUrlWithErrorParams(refreshUrl, "trustedChannelEstablishmentFailed", ex.getMessage());
                throw new InvalidTCTokenElement(refreshUrlAsUrl.toString(), (Throwable)ex);
            }
            catch (IOException | URISyntaxException | ResourceException | ValidationError | InvalidAddressException ex1) {
                String errorUrl = this.token.getComErrorAddressWithParams("communicationError");
                throw new InvalidTCTokenElement(errorUrl, (I18nKey)ErrorTranslations.INVALID_REFRESH_ADDRESS, (Throwable)ex1, new Object[0]);
            }
        }
        String errorUrl = this.token.getComErrorAddressWithParams("communicationError");
        throw new InvalidTCTokenElement(errorUrl, (I18nKey)ErrorTranslations.NO_REFRESH_ADDRESS, new Object[0]);
    }

    private void checkUserCancellation() throws InvalidRedirectUrlException, InvalidTCTokenElement, UserCancellationException {
        DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
        UserCancellationException ex = (UserCancellationException)dynCtx.get("card_selection_canceld");
        if (ex != null) {
            this.determineRefreshAddress(ex);
        }
    }
}

