/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import java.net.URISyntaxException;
import java.util.concurrent.Future;
import oasis.names.tc.dss._1_0.core.schema.Result;
import org.openecard.addon.bind.BindingResult;
import org.openecard.addon.bind.BindingResultCode;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenHacks;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidRedirectUrlException;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.WSHelper;
import org.openecard.common.util.UrlBuilder;

public class TCTokenResponse
extends BindingResult {
    private static final I18n lang = I18n.getTranslation("tr03112");
    private Result result;
    private TCToken token;
    private Future<?> bindingTask;

    public Result getResult() {
        if (this.result == null) {
            this.result = WSHelper.makeResultOK();
        }
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setTCToken(TCToken token) {
        this.token = token;
    }

    public TCToken getTCToken() {
        return this.token;
    }

    public String getRefreshAddress() {
        return this.token.getRefreshAddress();
    }

    public void setRefreshAddress(String addr) {
        this.token.setRefreshAddress(addr);
    }

    public void setBindingTask(Future<?> bindingTask) {
        this.bindingTask = bindingTask;
    }

    public Future<?> getBindingTask() {
        return this.bindingTask;
    }

    public void finishResponse(boolean clearContext) throws InvalidRedirectUrlException {
        try {
            DynamicContext dynCtx = DynamicContext.getInstance("tr03112");
            UrlBuilder ub = UrlBuilder.fromUrl(this.getRefreshAddress());
            if ("http://www.bsi.bund.de/ecard/api/1.1/resultmajor#ok".equals(this.result.getResultMajor())) {
                this.setResultCode(BindingResultCode.REDIRECT);
                String refreshURL = ub.queryParam("ResultMajor", "ok").build().toString();
                this.getAuxResultData().put("org.openecard.addon.bind.aux_data.redirect_location", refreshURL);
            } else {
                boolean isRefreshAddressValid = (Boolean)dynCtx.get("is_refresh_url_valid");
                this.setResultCode(BindingResultCode.REDIRECT);
                String fixedMinor = TCTokenHacks.fixResultMinor(this.result.getResultMinor());
                String refreshURL = isRefreshAddressValid ? ub.queryParam("ResultMajor", "error").queryParamUrl("ResultMinor", fixedMinor).build().toString() : this.token.getComErrorAddressWithParams(this.result.getResultMinor());
                this.getAuxResultData().put("org.openecard.addon.bind.aux_data.redirect_location", refreshURL);
                if (this.result.getResultMessage().getValue() != null) {
                    this.setResultMessage(this.result.getResultMessage().getValue());
                }
            }
            if (!clearContext) {
                dynCtx.clear();
                DynamicContext.remove();
            }
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(lang.getOriginalMessage(ErrorTranslations.INVALID_URL, new Object[0]), ex);
        }
    }
}

