/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import iso.std.iso_iec._24727.tech.schema.ConnectionHandleType;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.openecard.addon.Context;
import org.openecard.addons.tr03124.gui.CardMonitorTask;
import org.openecard.addons.tr03124.gui.CardSelectionAction;
import org.openecard.addons.tr03124.gui.CardSelectionStep;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenContext;
import org.openecard.binding.tctoken.ex.AuthServerException;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidAddressException;
import org.openecard.binding.tctoken.ex.InvalidRedirectUrlException;
import org.openecard.binding.tctoken.ex.InvalidTCTokenElement;
import org.openecard.binding.tctoken.ex.InvalidTCTokenException;
import org.openecard.binding.tctoken.ex.InvalidTCTokenUrlException;
import org.openecard.binding.tctoken.ex.MissingActivationParameterException;
import org.openecard.binding.tctoken.ex.SecurityViolationException;
import org.openecard.binding.tctoken.ex.UserCancellationException;
import org.openecard.bouncycastle.tls.TlsServerCertificate;
import org.openecard.common.AppVersion;
import org.openecard.common.DynamicContext;
import org.openecard.common.I18n;
import org.openecard.common.I18nKey;
import org.openecard.common.event.EventType;
import org.openecard.common.interfaces.CardRecognition;
import org.openecard.common.interfaces.EventCallback;
import org.openecard.common.sal.util.InsertCardDialog;
import org.openecard.common.util.ByteUtils;
import org.openecard.common.util.Pair;
import org.openecard.common.util.StringUtils;
import org.openecard.common.util.UrlBuilder;
import org.openecard.gui.ResultStatus;
import org.openecard.gui.UserConsent;
import org.openecard.gui.UserConsentNavigator;
import org.openecard.gui.definition.UserConsentDescription;
import org.openecard.gui.executor.ExecutionEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCTokenRequest {
    private static final Logger LOG = LoggerFactory.getLogger(TCTokenRequest.class);
    private static final I18n LANG = I18n.getTranslation("tr03112");
    private TCToken token;
    private String ifdName;
    private BigInteger slotIndex;
    private byte[] contextHandle;
    private String cardType = "http://bsi.bund.de/cif/npa.xml";
    private boolean tokenFromObject;
    private List<Pair<URL, TlsServerCertificate>> certificates;
    private URL tcTokenURL;
    private TCTokenContext tokenCtx;

    public static TCTokenRequest convert(Map<String, String> parameters, Context ctx) throws InvalidTCTokenException, MissingActivationParameterException, AuthServerException, InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, InvalidAddressException, UserCancellationException {
        if (parameters.containsKey("tcTokenURL")) {
            TCTokenRequest result = TCTokenRequest.parseTCTokenRequestURI(parameters, ctx);
            result.tokenFromObject = false;
            return result;
        }
        throw new MissingActivationParameterException((I18nKey)ErrorTranslations.NO_PARAMS, new Object[0]);
    }

    private static TCTokenRequest parseTCTokenRequestURI(Map<String, String> queries, Context ctx) throws InvalidTCTokenException, MissingActivationParameterException, AuthServerException, InvalidRedirectUrlException, InvalidTCTokenElement, InvalidTCTokenUrlException, SecurityViolationException, InvalidAddressException, UserCancellationException {
        Object dynCtx;
        TCTokenRequest tcTokenRequest = new TCTokenRequest();
        try {
            ConnectionHandleType handle;
            String[] types;
            if (queries.containsKey("cardTypes") || queries.containsKey("cardType")) {
                types = queries.containsKey("cardType") ? new String[]{queries.get("cardType")} : queries.get("cardTypes").split(",");
                handle = TCTokenRequest.findCard(types, ctx);
                TCTokenRequest.setIfdName(queries, handle.getIFDName());
                TCTokenRequest.setContextHandle(queries, handle.getContextHandle());
                TCTokenRequest.setSlotIndex(queries, handle.getSlotIndex());
                TCTokenRequest.addTokenUrlParameter(queries, handle.getRecognitionInfo());
            } else {
                types = new String[]{tcTokenRequest.cardType};
                handle = TCTokenRequest.findCard(types, ctx);
                TCTokenRequest.setIfdName(queries, handle.getIFDName());
                TCTokenRequest.setContextHandle(queries, handle.getContextHandle());
                TCTokenRequest.setSlotIndex(queries, handle.getSlotIndex());
            }
        }
        catch (UserCancellationException ex) {
            if (queries.containsKey("cardTypes")) {
                TCTokenRequest.addTokenUrlParameter(queries, queries.get("cardTypes").split(",")[0]);
            }
            LOG.warn("The user aborted the CardInsertion dialog.", ex);
            dynCtx = DynamicContext.getInstance("tr03112");
            ((DynamicContext)dynCtx).put("card_selection_canceld", ex);
        }
        String activationTokenUrl = null;
        block18: for (Map.Entry entry : queries.entrySet()) {
            String k = (String)entry.getKey();
            k = k == null ? "" : k;
            String v = (String)entry.getValue();
            if (v == null || v.isEmpty()) {
                LOG.info("Skipping query parameter '{}' because it does not contain a value.", (Object)k);
                continue;
            }
            switch (k) {
                case "tcTokenURL": {
                    activationTokenUrl = v;
                    continue block18;
                }
                case "ifdName": {
                    tcTokenRequest.ifdName = v;
                    continue block18;
                }
                case "contextHandle": {
                    tcTokenRequest.contextHandle = StringUtils.toByteArray(v);
                    continue block18;
                }
                case "slotIndex": {
                    tcTokenRequest.slotIndex = new BigInteger(v);
                    continue block18;
                }
                case "cardType": {
                    tcTokenRequest.cardType = v;
                    continue block18;
                }
            }
            LOG.info("Unknown query element: {}", (Object)k);
        }
        dynCtx = DynamicContext.getInstance("tr03112");
        ((DynamicContext)dynCtx).put("activation_card_type", tcTokenRequest.cardType);
        if (activationTokenUrl != null) {
            try {
                TCTokenContext tokenCtx;
                URL uRL = new URL(activationTokenUrl);
                tcTokenRequest.tokenCtx = tokenCtx = TCTokenContext.generateTCToken(uRL);
                tcTokenRequest.token = tokenCtx.getToken();
                tcTokenRequest.certificates = tokenCtx.getCerts();
                tcTokenRequest.tcTokenURL = uRL;
            }
            catch (MalformedURLException malformedURLException) {
                throw new InvalidTCTokenUrlException((I18nKey)ErrorTranslations.INVALID_TCTOKEN_URL, (Throwable)malformedURLException, activationTokenUrl);
            }
        }
        if (tcTokenRequest.token == null) {
            throw new MissingActivationParameterException((I18nKey)ErrorTranslations.NO_TOKEN, new Object[0]);
        }
        return tcTokenRequest;
    }

    private static ConnectionHandleType findCard(@Nonnull String[] types, @Nonnull Context ctx) throws MissingActivationParameterException, UserCancellationException {
        ConnectionHandleType handle;
        CardRecognition rec = ctx.getRecognition();
        HashMap<String, String> namesAndType = new HashMap<String, String>();
        for (String type : types) {
            namesAndType.put(rec.getTranslatedCardName(type), type);
        }
        InsertCardDialog insCardDiag = new InsertCardDialog(ctx.getUserConsent(), ctx.getCardStates(), namesAndType, ctx.getEventDispatcher());
        List<ConnectionHandleType> usableCards = insCardDiag.show();
        if (usableCards == null) {
            throw new UserCancellationException(null, LANG.translationForKey(ErrorTranslations.CARD_INSERTION_ABORT, new Object[0]));
        }
        if (usableCards.size() > 1) {
            UserConsentDescription ucd = new UserConsentDescription(LANG.translationForKey("card.selection.heading.uc", AppVersion.getName()));
            String stepTitle = LANG.translationForKey("card.selection.heading.step", new Object[0]);
            CardSelectionStep step = new CardSelectionStep(stepTitle, usableCards, ctx.getRecognition());
            ArrayList<String> types2 = new ArrayList<String>();
            types2.addAll(namesAndType.values());
            CardMonitorTask task = new CardMonitorTask(types2, step);
            ArrayList<EventType> events = new ArrayList<EventType>();
            events.add(EventType.CARD_REMOVED);
            events.add(EventType.CARD_RECOGNIZED);
            ctx.getEventDispatcher().add((EventCallback)task, (EventType[])events.toArray());
            step.setBackgroundTask(task);
            CardSelectionAction action = new CardSelectionAction(step, usableCards, types2, ctx);
            step.setAction(action);
            ucd.getSteps().add(step);
            UserConsent uc = ctx.getUserConsent();
            UserConsentNavigator ucNav = uc.obtainNavigator(ucd);
            ExecutionEngine exec = new ExecutionEngine(ucNav);
            ResultStatus resStatus = exec.process();
            if (resStatus != ResultStatus.OK) {
                throw new MissingActivationParameterException((I18nKey)ErrorTranslations.CARD_SELECTION_ABORT, new Object[0]);
            }
            handle = action.getResult();
            ctx.getEventDispatcher().del(task);
        } else {
            handle = usableCards.get(0);
        }
        return handle;
    }

    private static void setIfdName(@Nonnull Map<String, String> queries, @Nonnull String ifdName) {
        if (!ifdName.isEmpty()) {
            queries.put("ifdName", ifdName);
        }
    }

    private static void setContextHandle(@Nonnull Map<String, String> queries, @Nonnull byte[] contextHandle) {
        if (contextHandle.length > 0) {
            queries.put("contextHandle", ByteUtils.toHexString(contextHandle));
        }
    }

    private static void setSlotIndex(@Nonnull Map<String, String> queries, @Nonnull BigInteger index) {
        queries.put("slotIndex", index.toString());
    }

    private static void addTokenUrlParameter(@Nonnull Map<String, String> queries, @Nonnull ConnectionHandleType.RecognitionInfo recInfo) {
        if (queries.containsKey("tcTokenURL")) {
            String tcTokenURL = queries.get("tcTokenURL");
            try {
                UrlBuilder builder = UrlBuilder.fromUrl(tcTokenURL);
                builder = builder.queryParam("type", recInfo.getCardType(), true);
                queries.put("tcTokenURL", builder.build().toString());
                queries.put("cardType", recInfo.getCardType());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private static void addTokenUrlParameter(@Nonnull Map<String, String> queries, @Nonnull String selectedCardType) {
        if (queries.containsKey("tcTokenURL")) {
            String tcTokenURL = queries.get("tcTokenURL");
            try {
                UrlBuilder builder = UrlBuilder.fromUrl(tcTokenURL);
                builder = builder.queryParam("type", selectedCardType, true);
                queries.put("tcTokenURL", builder.build().toString());
                queries.put("cardType", selectedCardType);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    public TCToken getTCToken() {
        return this.token;
    }

    public String getIFDName() {
        return this.ifdName;
    }

    public byte[] getContextHandle() {
        return this.contextHandle;
    }

    public BigInteger getSlotIndex() {
        return this.slotIndex;
    }

    public String getCardType() {
        return this.cardType;
    }

    public boolean isTokenFromObject() {
        return this.tokenFromObject;
    }

    public List<Pair<URL, TlsServerCertificate>> getCertificates() {
        return this.certificates;
    }

    public URL getTCTokenURL() {
        return this.tcTokenURL;
    }

    public TCTokenContext getTokenContext() {
        return this.tokenCtx;
    }
}

