/*
 * Decompiled with CFR 0.152.
 */
package org.openecard.binding.tctoken;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openecard.binding.tctoken.TCToken;
import org.openecard.binding.tctoken.TCTokenSAXHandler;
import org.openecard.binding.tctoken.ex.ErrorTranslations;
import org.openecard.binding.tctoken.ex.InvalidTCTokenException;
import org.openecard.common.I18n;
import org.openecard.common.I18nKey;
import org.openecard.common.io.LimitedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class TCTokenParser {
    private static final Logger logger = LoggerFactory.getLogger(TCTokenParser.class);
    private final I18n lang = I18n.getTranslation("tr03112");
    private SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    private TCTokenSAXHandler saxHandler = new TCTokenSAXHandler();

    public TCTokenParser() {
        try {
            this.saxFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException | SAXNotRecognizedException | SAXNotSupportedException ex) {
            logger.error(ex.getMessage(), ex);
            throw new IllegalArgumentException(this.lang.getOriginalMessage(ErrorTranslations.UNSUPPORTED_FEATURE, new Object[0]), ex);
        }
    }

    public List<TCToken> parse(@Nonnull String data) throws InvalidTCTokenException {
        return this.parse(new ByteArrayInputStream(data.getBytes()));
    }

    public List<TCToken> parse(@Nonnull InputStream inputStream) throws InvalidTCTokenException {
        try {
            SAXParser saxParser = this.saxFactory.newSAXParser();
            LimitedInputStream stream = new LimitedInputStream(inputStream);
            saxParser.parse((InputStream)stream, (DefaultHandler)this.saxHandler);
            List<TCToken> tokens = this.saxHandler.getTCTokens();
            return tokens;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            logger.error(ex.getMessage(), ex);
            throw new InvalidTCTokenException((I18nKey)ErrorTranslations.MALFORMED_TOKEN, (Throwable)ex, new Object[0]);
        }
    }
}

